/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.logic;

import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.natsserver.config.NatsStreamingConfig;
import berlin.yuna.natsserver.logic.NatsBase;
import berlin.yuna.natsserver.logic.NatsUtils;
import berlin.yuna.natsserver.model.MapValue;
import berlin.yuna.natsserver.model.NatsStartException;
import berlin.yuna.natsserver.model.ValueSource;
import java.net.BindException;
import java.net.PortUnreachableException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class NatsStreaming
extends NatsBase {
    public NatsStreaming() {
        super(new ArrayList<String>());
    }

    public NatsStreaming(List<String> customArgs) {
        super(customArgs);
    }

    public NatsStreaming(int port) {
        this();
        this.config(NatsStreamingConfig.PORT, String.valueOf(port));
    }

    public NatsStreaming(String ... kv) {
        this();
        this.config(kv);
    }

    public Map<NatsStreamingConfig, MapValue> config() {
        return this.config;
    }

    public NatsStreaming config(NatsStreamingConfig key, String value) {
        this.config.remove((Object)key);
        if (key.desc().startsWith("[/]")) {
            if (value.equals("true")) {
                this.addConfig(ValueSource.DSL, key, value);
            }
        } else {
            this.addConfig(ValueSource.DSL, key, value);
        }
        return this;
    }

    public NatsStreaming config(Map<NatsStreamingConfig, String> config) {
        config.forEach((key, value) -> this.addConfig(ValueSource.DSL, (NatsStreamingConfig)((Object)key), (String)value));
        return this;
    }

    public NatsStreaming config(String ... kv) {
        boolean isKey = true;
        String key = null;
        for (String property : kv) {
            if (isKey) {
                key = property;
            } else {
                this.config(NatsStreamingConfig.valueOf(key.toUpperCase().replace("-", "")), property);
            }
            isKey = !isKey;
        }
        return this;
    }

    public NatsStreaming tryStart() {
        return this.tryStart(TimeUnit.SECONDS.toMillis(10L));
    }

    public NatsStreaming tryStart(long timeoutMs) {
        try {
            this.start(timeoutMs);
            return this;
        }
        catch (Exception e) {
            throw new NatsStartException(e);
        }
    }

    public NatsStreaming start() throws Exception {
        return this.start(TimeUnit.SECONDS.toMillis(10L));
    }

    public synchronized NatsStreaming start(long timeoutMs) throws Exception {
        if (this.process != null) {
            this.logger.severe(() -> String.format("[%s] is already running", this.name));
            return this;
        }
        this.setNextFreePort();
        int port = this.port();
        NatsUtils.validatePort(port, timeoutMs, true, () -> new BindException("Address already in use [" + port + "]"));
        Path binaryPath = this.downloadNats();
        this.logger.fine(() -> String.format("Starting [%s] port [%s] version [%s]", this.name, port, this.getValue(NatsStreamingConfig.NATS_SYSTEM)));
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.logger::info;
        Consumer[] consumerArray2 = new Consumer[1];
        consumerArray2[0] = this.logger::severe;
        Terminal terminal = new Terminal().consumerInfo(consumerArray).consumerError(consumerArray2).timeoutMs(timeoutMs > 0L ? timeoutMs : 10000L).breakOnError(false).execute(this.prepareCommand());
        this.process = terminal.process();
        NatsUtils.validatePort(port, timeoutMs, false, () -> new PortUnreachableException(this.name + " failed to start with port [" + port + "]"));
        this.logger.info(() -> String.format("Started [%s] port [%s] version [%s] pid [%s]", this.name, port, this.getValue(NatsStreamingConfig.NATS_SYSTEM), this.pid()));
        return this;
    }

    @Override
    public void close() {
        this.stop();
    }

    public NatsStreaming stop() {
        return this.stop(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NatsStreaming stop(long timeoutMs) {
        try {
            this.logger.info(() -> String.format("Stopping [%s]", this.name));
            if (this.pid() != -1) {
                Consumer[] consumerArray = new Consumer[1];
                consumerArray[0] = this.logger::info;
                Consumer[] consumerArray2 = new Consumer[1];
                consumerArray2[0] = this.logger::severe;
                new Terminal().consumerInfo(consumerArray).consumerError(consumerArray2).breakOnError(false).execute(this.binaryFile() + " " + NatsStreamingConfig.SIGNAL.key() + " stop=" + this.pid());
            }
            this.process.destroy();
            this.process.waitFor();
        }
        catch (InterruptedException | NullPointerException ignored) {
            this.logger.warning(() -> String.format("Could not find process to stop [%s]", this.name));
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.port() > -1) {
                NatsUtils.waitForPort(this.port(), timeoutMs, true);
                this.logger.info(() -> String.format("Stopped [%s]", this.name));
            }
        }
        this.deletePidFile();
        return this;
    }
}

