/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.config;

import berlin.yuna.natsserver.config.NatsStreamingConfig;
import berlin.yuna.natsserver.config.NatsStreamingOptionsBuilder;
import io.nats.commons.NatsOptions;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NatsStreamingOptions
implements NatsOptions {
    protected final Logger logger;
    protected final Map<NatsStreamingConfig, String> config;

    public NatsStreamingOptions(Logger logger, Map<NatsStreamingConfig, String> config) {
        this.logger = logger;
        this.config = config == null ? new EnumMap<NatsStreamingConfig, String>(NatsStreamingConfig.class) : new EnumMap<NatsStreamingConfig, String>(config);
    }

    public String version() {
        return this.config.get((Object)NatsStreamingConfig.NATS_STREAMING_VERSION);
    }

    @Override
    public Integer port() {
        return NatsStreamingOptionsBuilder.getValueI(this.config, NatsStreamingConfig.PORT);
    }

    @Override
    public Boolean jetStream() {
        return false;
    }

    @Override
    public Boolean debug() {
        return NatsStreamingOptionsBuilder.getValueB(this.config, NatsStreamingConfig.DEBUG);
    }

    @Override
    public Path configFile() {
        return NatsStreamingOptionsBuilder.getValue(this.config, x$0 -> Path.of(x$0, new String[0]), NatsStreamingConfig.CONFIG);
    }

    @Override
    public String[] customArgs() {
        return NatsStreamingOptionsBuilder.getValue(this.config, args -> args.split("&&"), NatsStreamingConfig.NATS_ARGS);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public Level logLevel() {
        return NatsStreamingOptionsBuilder.getValue(this.config, NatsStreamingConfig::logLevelOf, NatsStreamingConfig.NATS_LOG_LEVEL);
    }

    public Map<NatsStreamingConfig, String> config() {
        return this.config;
    }

    public static NatsStreamingOptionsBuilder natsStreamingBuilder() {
        return new NatsStreamingOptionsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NatsStreamingOptions that = (NatsStreamingOptions)o;
        return Objects.equals(this.logger, that.logger) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.logger, this.config);
    }
}

