/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.logic;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.clu.logic.Terminal;
import berlin.yuna.clu.model.OsType;
import berlin.yuna.clu.model.ThrowingFunction;
import berlin.yuna.natsserver.config.NatsStreamingConfig;
import berlin.yuna.natsserver.config.NatsStreamingOptions;
import berlin.yuna.natsserver.config.NatsStreamingOptionsBuilder;
import berlin.yuna.natsserver.logic.NatsUtils;
import berlin.yuna.natsserver.model.MapValue;
import berlin.yuna.natsserver.model.ValueSource;
import berlin.yuna.natsserver.model.exception.NatsStreamingStartException;
import io.nats.commons.NatsInterface;
import io.nats.commons.NatsOptions;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.PortUnreachableException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class NatsStreaming
implements NatsInterface {
    protected final String name;
    protected final Long timeoutMs;
    private final Logger logger;
    protected final Map<NatsStreamingConfig, MapValue> configMap = new ConcurrentHashMap<NatsStreamingConfig, MapValue>();
    protected final AtomicReference<Terminal> terminal = new AtomicReference<Object>(null);
    public static final String NATS_PREFIX = "NATS_";
    private static final String TMP_DIR = "java.io.tmpdir";

    public NatsStreaming() {
        this(NatsStreamingOptions.natsStreamingBuilder().autostart(true).build());
    }

    public NatsStreaming(int port) {
        this(NatsStreamingOptions.natsStreamingBuilder().port(port).build());
    }

    public NatsStreaming(NatsStreamingOptionsBuilder natsOptions) {
        this(natsOptions.build());
    }

    public NatsStreaming(NatsOptions natsOptions) {
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
        AtomicLong timeoutMsTmp = new AtomicLong(-1L);
        if (natsOptions instanceof NatsStreamingOptions) {
            ((NatsStreamingOptions)natsOptions).config().forEach(this::addConfig);
        }
        this.setDefaultConfig();
        this.setEnvConfig();
        this.setConfigFromProperties();
        this.setConfigFromNatsStreamingOptions(natsOptions);
        this.name = this.getValue(NatsStreamingConfig.NATS_LOG_NAME);
        this.timeoutMs = Long.parseLong(this.getValue(NatsStreamingConfig.NATS_TIMEOUT_MS));
        this.logger = Optional.ofNullable(natsOptions.logger()).orElse(Logger.getLogger(this.name));
        Optional.ofNullable(natsOptions.logLevel()).ifPresent(this.logger::setLevel);
        Optional.ofNullable(this.getValue(NatsStreamingConfig.NATS_AUTOSTART)).filter(Boolean::valueOf).ifPresent(autostart -> this.start());
    }

    public synchronized NatsStreaming start() {
        try {
            if (this.terminal.get() != null && this.terminal.get().running()) {
                this.logger.severe(() -> String.format("[%s] is already running", this.logger.getName()));
                return this;
            }
            this.downloadNats();
            int port = this.setNextFreePort();
            NatsUtils.validatePort(port, this.timeoutMs, true, () -> new BindException("Address already in use [" + port + "]"), () -> false);
            String command = this.prepareCommand();
            this.logger.info(() -> String.format("Starting [%s] port [%s] version [%s] command [%s]", this.name, port, this.getValue(NatsStreamingConfig.NATS_SYSTEM), command));
            this.startProcess(command);
            NatsUtils.validatePort(port, this.timeoutMs, false, () -> new PortUnreachableException(this.name + " failed to start with port [" + port + "]"), () -> this.terminal.get() == null);
            this.logger.info(() -> String.format("Started [%s] port [%s] version [%s] pid [%s]", this.name, port, this.getValue(NatsStreamingConfig.NATS_SYSTEM), this.pid()));
        }
        catch (Exception e) {
            throw new NatsStreamingStartException(e);
        }
        return this;
    }

    @Override
    public Process process() {
        return Optional.ofNullable(this.terminal.get()).map(Terminal::process).orElse(null);
    }

    @Override
    public String[] customArgs() {
        return Optional.ofNullable(this.getValue(NatsStreamingConfig.NATS_ARGS, () -> null)).map(args -> args.split("&&")).orElseGet(() -> new String[0]);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public Level loggingLevel() {
        return this.logger.getLevel();
    }

    @Override
    public Path binary() {
        return Paths.get(this.getValue(NatsStreamingConfig.NATS_BINARY_PATH, () -> Paths.get(NatsUtils.getEnv(TMP_DIR), this.getValue(NatsStreamingConfig.NATS_LOG_NAME).toLowerCase(), this.getValue(NatsStreamingConfig.NATS_LOG_NAME).toLowerCase() + "_" + this.getValue(NatsStreamingConfig.NATS_SYSTEM) + (SystemUtil.OS == OsType.OS_WINDOWS ? ".exe" : "")).toString()), new String[0]);
    }

    @Override
    public int port() {
        return Integer.parseInt(this.getValue(NatsStreamingConfig.PORT));
    }

    @Override
    public boolean jetStream() {
        return false;
    }

    @Override
    public boolean debug() {
        return Boolean.parseBoolean(this.getValue(NatsStreamingConfig.DV)) || Boolean.parseBoolean(this.getValue(NatsStreamingConfig.SDV)) || Boolean.parseBoolean(this.getValue(NatsStreamingConfig.DEBUG));
    }

    @Override
    public Path configFile() {
        return Optional.ofNullable(this.getValue(NatsStreamingConfig.CONFIG, () -> null)).map(x$0 -> Path.of(x$0, new String[0])).orElse(null);
    }

    public Path configPropertyFile() {
        return Optional.ofNullable(this.getValue(NatsStreamingConfig.NATS_PROPERTY_FILE, () -> null)).map(x$0 -> Path.of(x$0, new String[0])).orElse(null);
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public String getValue(NatsStreamingConfig key) {
        return this.getValue(key, () -> key.defaultValue() == null ? null : String.valueOf(key.defaultValue()));
    }

    public String getValue(NatsStreamingConfig key, Supplier<String> or) {
        return NatsUtils.resolveEnvs(Optional.ofNullable(this.configMap.get((Object)key)).map(MapValue::value).orElseGet(or), this.configMap);
    }

    public int pid() {
        try {
            return Integer.parseInt(String.join((CharSequence)" ", Files.readAllLines(this.pidFile(), StandardCharsets.UTF_8)).trim());
        }
        catch (IOException e) {
            return -1;
        }
    }

    public Path pidFile() {
        return Paths.get(this.getValue(NatsStreamingConfig.PID, () -> Paths.get(NatsUtils.getEnv(TMP_DIR), this.getValue(NatsStreamingConfig.NATS_LOG_NAME).toLowerCase(), this.port() + ".pid").toString()), new String[0]);
    }

    public String downloadUrl() {
        return this.getValue(NatsStreamingConfig.NATS_DOWNLOAD_URL);
    }

    @Override
    public String url() {
        return "nats://" + this.getValue(NatsStreamingConfig.ADDR) + ":" + this.port();
    }

    public Map<NatsStreamingConfig, String> config() {
        return this.configMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((MapValue)e.getValue()).value()));
    }

    protected void setConfigFromNatsStreamingOptions(NatsOptions natsOptions) {
        Optional.ofNullable(natsOptions.debug()).ifPresent(debug -> this.addConfig(NatsStreamingConfig.DV, debug));
        Optional.ofNullable(natsOptions.configFile()).ifPresent(config -> this.addConfig(NatsStreamingConfig.CONFIG, config));
        Optional.ofNullable(natsOptions.port()).ifPresent(port -> this.addConfig(NatsStreamingConfig.PORT, port));
        Optional.ofNullable(natsOptions.logger()).map(Logger::getName).ifPresent(loggerName -> this.addConfig(NatsStreamingConfig.NATS_LOG_NAME, loggerName));
    }

    protected void setConfigFromProperties() {
        NatsUtils.getPropertyFiles(Optional.ofNullable(this.getValue(NatsStreamingConfig.NATS_PROPERTY_FILE)).filter(NatsUtils::isNotEmpty).orElse("nats.properties")).forEach(path -> {
            Properties prop = new Properties();
            try (FileInputStream inputStream = new FileInputStream(path.toFile());){
                prop.load(inputStream);
            }
            catch (IOException e) {
                Logger.getLogger(this.getValue(NatsStreamingConfig.NATS_LOG_NAME)).severe("Unable to read property file [" + path.toUri() + "] cause of [" + e.getMessage() + "]");
            }
            prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.addConfig(ValueSource.FILE, NatsStreamingConfig.valueOf(String.valueOf(key).toUpperCase()), NatsUtils.removeQuotes((String)value))));
        });
    }

    protected void setDefaultConfig() {
        for (NatsStreamingConfig cfg : NatsStreamingConfig.values()) {
            String value = cfg.defaultValueStr();
            this.addConfig(ValueSource.DEFAULT, cfg, value);
        }
        this.addConfig(ValueSource.DEFAULT, NatsStreamingConfig.NATS_SYSTEM, NatsUtils.getSystem());
    }

    protected void setEnvConfig() {
        for (NatsStreamingConfig cfg : NatsStreamingConfig.values()) {
            this.addConfig(ValueSource.ENV, cfg, NatsUtils.getEnv((String)(cfg.name().startsWith(NATS_PREFIX) ? cfg.name() : NATS_PREFIX + cfg.name())));
        }
    }

    protected void addConfig(NatsStreamingConfig key, Object value) {
        if (value != null && !String.valueOf(this.getValue(key)).equals(String.valueOf(value))) {
            this.addConfig(ValueSource.DSL, key, String.valueOf(value));
        }
    }

    protected void addConfig(ValueSource source, NatsStreamingConfig key, String value) {
        if (value != null) {
            this.configMap.put(key, this.configMap.computeIfAbsent(key, val -> MapValue.mapValueOf(source, value)).update(source, value));
        }
    }

    protected int setNextFreePort() {
        if (Optional.ofNullable(this.getValue(NatsStreamingConfig.PORT, () -> null)).map(Integer::parseInt).orElse(-1) <= 0) {
            this.addConfig(this.configMap.get((Object)NatsStreamingConfig.PORT).source(), NatsStreamingConfig.PORT, String.valueOf(NatsUtils.getNextFreePort((Integer)NatsStreamingConfig.PORT.defaultValue())));
        }
        return this.port();
    }

    protected Path downloadNats() throws IOException {
        Path binaryPath = this.binary();
        Files.createDirectories(binaryPath.getParent(), new FileAttribute[0]);
        if (Files.notExists(binaryPath, new LinkOption[0])) {
            URL source = new URL(this.getValue(NatsStreamingConfig.NATS_DOWNLOAD_URL));
            NatsUtils.unzip(NatsUtils.download(source, Paths.get(this.binary().toString() + ".zip", new String[0])), binaryPath);
        }
        binaryPath.toFile().setExecutable(true);
        SystemUtil.setFilePermissions((Path)binaryPath, (PosixFilePermission[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OWNER_READ, PosixFilePermission.OTHERS_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OTHERS_WRITE});
        return binaryPath;
    }

    protected String prepareCommand() {
        StringBuilder command = new StringBuilder();
        this.setDefaultConfig();
        this.setEnvConfig();
        this.setConfigFromProperties();
        this.addConfig(ValueSource.DSL, NatsStreamingConfig.PID, this.pidFile().toString());
        command.append(this.binary().toString());
        this.configMap.forEach((key, mapValue) -> {
            if (!key.name().startsWith(NATS_PREFIX) && mapValue != null && NatsUtils.isNotEmpty(mapValue.value())) {
                if (key.isWritableValue() || !"false".equals(mapValue.value())) {
                    command.append(" ");
                    command.append(key.key());
                }
                if (key.isWritableValue()) {
                    command.append("=");
                    command.append(mapValue.value().trim().toLowerCase());
                }
            }
        });
        command.append(Arrays.stream(this.customArgs()).collect(Collectors.joining(" ", " ", "")));
        command.append(Arrays.stream(this.getValue(NatsStreamingConfig.NATS_ARGS, () -> "").split("&&")).map(String::trim).collect(Collectors.joining(" ", " ", "")));
        return command.toString();
    }

    protected synchronized void shutdown() {
        try {
            this.sendStopSignal();
            this.waitForShutDown(this.timeoutMs);
            if (this.terminal.get() != null) {
                this.terminal.get().process().destroy();
                this.terminal.get().process().waitFor();
            }
        }
        catch (InterruptedException ignored) {
            this.logger.warning(() -> String.format("Could not find process to stop [%s]", this.name));
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.port() > -1) {
                NatsUtils.waitForPort(this.port(), this.timeoutMs, true);
                this.logger.info(() -> String.format("Stopped [%s]", this.name));
            }
            this.terminal.set(null);
        }
        this.deletePidFile();
    }

    protected void sendStopSignal() {
        this.logger.info(() -> String.format("Stopping [%s]", this.name));
        if (this.pid() != -1) {
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = this.logger::info;
            Consumer[] consumerArray2 = new Consumer[1];
            consumerArray2[0] = this.logger::severe;
            new Terminal().consumerInfoStream(consumerArray).consumerErrorStream(consumerArray2).breakOnError(false).execute(this.binary() + " " + NatsStreamingConfig.SIGNAL.key() + " stop=" + this.pid());
        }
    }

    protected void waitForShutDown(long timeoutMs) {
        Optional.of(this.port()).filter(port -> port > 0).ifPresent(port -> {
            this.logger.info(() -> String.format("Stopped [%s]", this.name));
            NatsUtils.waitForPort(port, timeoutMs, true);
        });
    }

    protected void deletePidFile() {
        NatsUtils.ignoreException((ThrowingFunction<Long, Long>)((ThrowingFunction)run -> {
            Files.deleteIfExists(this.pidFile());
            return run;
        }));
    }

    protected void startProcess(String command) {
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.logger::info;
        this.terminal.set(new Terminal().timeoutMs(this.timeoutMs.longValue()).breakOnError(false).consumerErrorStream(consumerArray).consumerInfoStream(new Consumer[]{serve -> {
            this.logger.severe((String)serve);
            this.terminal.set(null);
        }}).execute(command, null));
    }

    public String toString() {
        return "Nats{name=" + this.name + ", pid='" + this.pid() + "', port=" + this.port() + ", configs=" + this.configMap.size() + "}";
    }
}

