/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.config;

import berlin.yuna.natsserver.config.NatsStreamingConfig;
import berlin.yuna.natsserver.config.NatsStreamingOptions;
import berlin.yuna.natsserver.config.NatsStreamingVersion;
import berlin.yuna.natsserver.logic.NatsStreaming;
import berlin.yuna.natsserver.logic.NatsUtils;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NatsStreamingOptionsBuilder {
    protected Logger logger;
    protected Map<NatsStreamingConfig, String> configMap = new EnumMap<NatsStreamingConfig, String>(NatsStreamingConfig.class);

    protected NatsStreamingOptionsBuilder() {
    }

    public NatsStreamingOptions build() {
        return new NatsStreamingOptions(this.logger, this.configMap);
    }

    public NatsStreaming nats() {
        return new NatsStreaming(this);
    }

    public String version() {
        return this.configMap.get((Object)NatsStreamingConfig.NATS_STREAMING_VERSION);
    }

    public NatsStreamingOptionsBuilder version(String version) {
        this.configMap.put(NatsStreamingConfig.NATS_STREAMING_VERSION, Optional.ofNullable(version).filter(NatsUtils::isNotEmpty).map(v -> v.toLowerCase().startsWith("v") ? v : "v" + v).orElse(null));
        return this;
    }

    public NatsStreamingOptionsBuilder version(NatsStreamingVersion version) {
        this.configMap.put(NatsStreamingConfig.NATS_STREAMING_VERSION, version != null ? version.value() : null);
        return this;
    }

    public Integer port() {
        return NatsStreamingOptionsBuilder.getValueI(this.configMap, NatsStreamingConfig.PORT);
    }

    public NatsStreamingOptionsBuilder port(Integer port) {
        NatsStreamingOptionsBuilder.setValueI(this.configMap, NatsStreamingConfig.PORT, port);
        return this;
    }

    public Boolean debug() {
        return NatsStreamingOptionsBuilder.getValueB(this.configMap, NatsStreamingConfig.DEBUG);
    }

    public NatsStreamingOptionsBuilder debug(Boolean debug) {
        NatsStreamingOptionsBuilder.setValueB(this.configMap, NatsStreamingConfig.DEBUG, debug);
        return this;
    }

    public Path configFile() {
        return NatsStreamingOptionsBuilder.getValue(this.configMap, x$0 -> Path.of(x$0, new String[0]), NatsStreamingConfig.CONFIG);
    }

    public NatsStreamingOptionsBuilder configFile(Path configFile) {
        NatsStreamingOptionsBuilder.setValue(this.configMap, Path::toString, NatsStreamingConfig.CONFIG, configFile);
        return this;
    }

    public Path configPropertyFile() {
        return NatsStreamingOptionsBuilder.getValue(this.configMap, x$0 -> Path.of(x$0, new String[0]), NatsStreamingConfig.NATS_PROPERTY_FILE);
    }

    public NatsStreamingOptionsBuilder configPropertyFile(Path configFile) {
        NatsStreamingOptionsBuilder.setValue(this.configMap, Path::toString, NatsStreamingConfig.NATS_PROPERTY_FILE, configFile);
        return this;
    }

    public String[] customArgs() {
        return NatsStreamingOptionsBuilder.getValue(this.configMap, args -> args.split("&&"), NatsStreamingConfig.NATS_ARGS);
    }

    public NatsStreamingOptionsBuilder customArgs(String ... customArgs) {
        Optional.ofNullable(customArgs).ifPresent(value -> this.configMap.put(NatsStreamingConfig.NATS_ARGS, String.join((CharSequence)"&&", value)));
        return this;
    }

    public NatsStreamingOptionsBuilder addArgs(String ... customArgs) {
        String args = this.configMap.get((Object)NatsStreamingConfig.NATS_ARGS);
        Optional.ofNullable(customArgs).ifPresent(value -> {
            if (args != null) {
                this.configMap.put(NatsStreamingConfig.NATS_ARGS, String.join((CharSequence)"&&", args, String.join((CharSequence)"&&", value)));
            } else {
                this.configMap.put(NatsStreamingConfig.NATS_ARGS, String.join((CharSequence)"&&", value));
            }
        });
        return this;
    }

    public Logger logger() {
        return this.logger;
    }

    public NatsStreamingOptionsBuilder logger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Level logLevel() {
        return NatsStreamingOptionsBuilder.getValue(this.configMap, NatsStreamingConfig::logLevelOf, NatsStreamingConfig.NATS_LOG_LEVEL);
    }

    public NatsStreamingOptionsBuilder logLevel(Level level) {
        NatsStreamingOptionsBuilder.setValue(this.configMap, Level::getName, NatsStreamingConfig.NATS_LOG_LEVEL, level);
        return this;
    }

    public Boolean autostart() {
        return NatsStreamingOptionsBuilder.getValueB(this.configMap, NatsStreamingConfig.NATS_AUTOSTART);
    }

    public NatsStreamingOptionsBuilder autostart(Boolean autostart) {
        NatsStreamingOptionsBuilder.setValueB(this.configMap, NatsStreamingConfig.NATS_AUTOSTART, autostart);
        return this;
    }

    public Boolean shutdownHook() {
        return NatsStreamingOptionsBuilder.getValueB(this.configMap, NatsStreamingConfig.NATS_SHUTDOWN_HOOK);
    }

    public NatsStreamingOptionsBuilder shutdownHook(Boolean enabled) {
        NatsStreamingOptionsBuilder.setValueB(this.configMap, NatsStreamingConfig.NATS_SHUTDOWN_HOOK, enabled);
        return this;
    }

    public Long timeoutMs() {
        return NatsStreamingOptionsBuilder.getValue(this.configMap, Long::parseLong, NatsStreamingConfig.NATS_TIMEOUT_MS);
    }

    public NatsStreamingOptionsBuilder timeoutMs(Number timeoutMs) {
        NatsStreamingOptionsBuilder.setValue(this.configMap, number -> String.valueOf(number.longValue()), NatsStreamingConfig.NATS_TIMEOUT_MS, timeoutMs);
        return this;
    }

    public Map<NatsStreamingConfig, String> configMap() {
        return this.configMap;
    }

    public NatsStreamingOptionsBuilder configMap(Map<NatsStreamingConfig, String> configMap) {
        this.configMap = new EnumMap<NatsStreamingConfig, String>(configMap);
        return this;
    }

    public NatsStreamingOptionsBuilder config(NatsStreamingConfig key, String value) {
        this.configMap.put(key, value);
        return this;
    }

    public NatsStreamingOptionsBuilder config(String ... kv) {
        for (int i = 0; i < kv.length - 1; i += 2) {
            this.config(NatsStreamingConfig.valueOf(kv[i].toUpperCase().replace("-", "")), kv[i + 1]);
        }
        return this;
    }

    protected static Integer getValueI(Map<NatsStreamingConfig, String> config, NatsStreamingConfig key) {
        return NatsStreamingOptionsBuilder.getValue(config, Integer::parseInt, key);
    }

    protected static Boolean getValueB(Map<NatsStreamingConfig, String> config, NatsStreamingConfig key) {
        return NatsStreamingOptionsBuilder.getValue(config, Boolean::parseBoolean, key);
    }

    protected static <T> T getValue(Map<NatsStreamingConfig, String> config, Function<String, T> map, NatsStreamingConfig key) {
        return Optional.ofNullable(config.get((Object)key)).map(map).orElse(null);
    }

    protected static void setValueI(Map<NatsStreamingConfig, String> config, NatsStreamingConfig key, Integer value) {
        NatsStreamingOptionsBuilder.setValue(config, Object::toString, key, value);
    }

    protected static void setValueB(Map<NatsStreamingConfig, String> config, NatsStreamingConfig key, Boolean value) {
        NatsStreamingOptionsBuilder.setValue(config, Object::toString, key, value);
    }

    protected static <T> void setValue(Map<NatsStreamingConfig, String> config, Function<T, String> map, NatsStreamingConfig key, T value) {
        Optional.ofNullable(value).map(map).ifPresent(val -> config.put(key, (String)val));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NatsStreamingOptionsBuilder that = (NatsStreamingOptionsBuilder)o;
        return Objects.equals(this.logger, that.logger) && Objects.equals(this.configMap, that.configMap);
    }

    public int hashCode() {
        return Objects.hash(this.logger, this.configMap);
    }
}

