/*
 * Decompiled with CFR 0.152.
 */
package berlin.yuna.natsserver.logic;

import berlin.yuna.clu.logic.SystemUtil;
import berlin.yuna.clu.model.ThrowingFunction;
import berlin.yuna.natsserver.config.NatsStreamingConfig;
import berlin.yuna.natsserver.model.MapValue;
import berlin.yuna.natsserver.model.exception.NatsStreamingDownloadException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class NatsUtils {
    private NatsUtils() {
    }

    public static String getEnv(String key) {
        return NatsUtils.getEnv(key, () -> null);
    }

    public static String getEnv(String key, Supplier<String> fallback) {
        return Optional.ofNullable(System.getProperty(key.toLowerCase())).or(() -> Optional.ofNullable(System.getProperty(key.toUpperCase()))).or(() -> Optional.ofNullable(System.getenv(key.toLowerCase()))).or(() -> Optional.ofNullable(System.getenv(key.toUpperCase()))).orElseGet(fallback);
    }

    public static String resolveEnvs(String input, Map<NatsStreamingConfig, MapValue> config) {
        int end;
        int start;
        Object result = input;
        while (result != null && (start = ((String)result).indexOf("%")) != -1 && (end = ((String)result).indexOf("%", start + 1)) != -1) {
            String key = ((String)result).substring(start + 1, end);
            result = ((String)result).substring(0, start) + NatsUtils.envValue(key, config) + ((String)result).substring(end + 1);
        }
        return result;
    }

    public static String getSystem() {
        return (NatsUtils.osString(SystemUtil.OS, null) + NatsUtils.osString(SystemUtil.OS_ARCH, "-") + NatsUtils.osString(SystemUtil.OS_ARCH_TYPE, null)).replace("mips64", "linux-mips64le").replace("darwin-386", "darwin-amd64");
    }

    public static Path download(URL source, Path target) {
        Path path;
        FileOutputStream fos = new FileOutputStream(target.toFile());
        try {
            fos.getChannel().transferFrom(Channels.newChannel(source.openStream()), 0L, Long.MAX_VALUE);
            path = target;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new NatsStreamingDownloadException(e);
            }
        }
        fos.close();
        return path;
    }

    public static Path unzip(Path source, Path target) throws IOException {
        try (ZipFile zipFile = new ZipFile(source.toFile());){
            ZipEntry max = zipFile.stream().max(Comparator.comparingLong(ZipEntry::getSize)).orElseThrow(() -> new IllegalStateException("File not found " + String.valueOf(zipFile)));
            Files.copy(zipFile.getInputStream(max), target, new CopyOption[0]);
        }
        catch (ZipException ze) {
            Files.copy(new FileInputStream(source.toFile()), target, new CopyOption[0]);
        }
        Files.deleteIfExists(source);
        return target;
    }

    public static void validatePort(int port, long timeoutMs, boolean untilFree, Supplier<Exception> onFail, BooleanSupplier disrupt) throws Exception {
        if (!NatsUtils.waitForPort(port, timeoutMs, untilFree, disrupt)) {
            throw onFail.get();
        }
    }

    public static boolean waitForPort(int port, long timeoutMs, boolean isFree) {
        return NatsUtils.waitForPort(port, timeoutMs, isFree, () -> false);
    }

    public static boolean waitForPort(int port, long timeoutMs, boolean isFree, BooleanSupplier disrupt) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeoutMs) {
            if (NatsUtils.isPortAvailable(port) == isFree) {
                return true;
            }
            if (disrupt.getAsBoolean()) {
                return false;
            }
            Thread.yield();
        }
        return timeoutMs <= 0L;
    }

    public static boolean isPortAvailable(int port) {
        try {
            new Socket("localhost", port).close();
            return false;
        }
        catch (IOException | IllegalArgumentException e) {
            return true;
        }
    }

    public static int getNextFreePort(int startPort) {
        for (int i = 1; i < 1024; ++i) {
            int port = i + startPort;
            if (NatsUtils.isPortInUse(port)) continue;
            return port;
        }
        throw new IllegalStateException("Could not find any free port");
    }

    public static boolean isPortInUse(int portNumber) {
        try {
            new Socket("localhost", portNumber).close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty() && !string.isBlank();
    }

    private static String envValue(String key, Map<NatsStreamingConfig, MapValue> config) {
        return Optional.ofNullable(config.get((Object)NatsStreamingConfig.valueOf(key))).map(MapValue::value).orElseGet(() -> NatsUtils.getEnv(key, () -> ""));
    }

    public static String removeQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static List<Path> getPropertyFiles(String fileName) {
        ArrayList<Path> result = new ArrayList<Path>();
        Path filePath = Optional.ofNullable(fileName).map(x$0 -> Path.of(x$0, new String[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).orElse(null);
        try (Stream<Path> walk = Files.walk(Paths.get(System.getProperty("user.dir"), new String[0]), new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> filePath != null && filePath.equals(path) || path.getFileName().toString().equals(fileName) || path.getFileName().toString().equals("nats.properties")).forEach(result::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static String osString(Enum<?> input, String prefix) {
        if (input != null && !input.name().contains("UNKNOWN")) {
            return (prefix == null ? "" : "-") + input.toString().toLowerCase().replace("86", "386").replace("intel", "").replace("_", "");
        }
        return "";
    }

    public static void ignoreException(ThrowingFunction<Long, Long> function) {
        try {
            function.acceptThrows((Object)System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

