/*
 * Decompiled with CFR 0.152.
 */
package best.skn.mail.services;

import best.skn.mail.services.MailSenderInterface;
import best.skn.mail.services.MailSenderMessage;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.File;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import reactor.core.publisher.Mono;

@Service
public class MailSenderService
implements MailSenderInterface {
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private TemplateEngine templateEngine;

    @Override
    public Mono<String> sendMail(String from, String to, String subject, String body) throws MessagingException {
        try {
            if (from == null || to == null || subject == null || body == null) {
                return Mono.just((Object)MailSenderMessage.parameterError());
            }
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, 3, StandardCharsets.UTF_8.name());
            helper.setFrom(from);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(body);
            this.mailSender.send(message);
            return MailSenderMessage.sendMailSuccess();
        }
        catch (MessagingException e) {
            return MailSenderMessage.exceptionError(e.getMessage());
        }
    }

    @Override
    public Mono<String> sendMailWithAttachment(String from, String to, String subject, String body, String filePath) throws MessagingException {
        try {
            if (from == null || to == null || subject == null || body == null || filePath == null) {
                return Mono.just((Object)MailSenderMessage.parameterError());
            }
            FileSystemResource file = new FileSystemResource(new File(filePath));
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, 3, StandardCharsets.UTF_8.name());
            helper.setFrom(from);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(body);
            helper.addAttachment(file.getFilename(), (InputStreamSource)file);
            this.mailSender.send(message);
            return MailSenderMessage.sendMailWithAttachmentSuccess();
        }
        catch (MessagingException e) {
            return MailSenderMessage.exceptionError(e.getMessage());
        }
    }

    @Override
    public Mono<String> sendMailWithHtmlTemplate(String from, String to, String subject, String templateName, Context context) throws MessagingException {
        try {
            if (from == null || to == null || subject == null || templateName == null || context == null) {
                return Mono.just((Object)MailSenderMessage.parameterError());
            }
            String htmlContent = this.templateEngine.process(templateName, (IContext)context);
            if (htmlContent == null) {
                return Mono.just((Object)MailSenderMessage.htmlContentError());
            }
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, 3, StandardCharsets.UTF_8.name());
            helper.setFrom(from);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(htmlContent, true);
            this.mailSender.send(message);
            return MailSenderMessage.sendMailWithHtmlTemplateSuccess();
        }
        catch (MessagingException e) {
            return MailSenderMessage.exceptionError(e.getMessage());
        }
    }

    @Override
    public Mono<String> sendMailWithHtmlTemplateAndAttachment(String from, String to, String subject, String templateName, Context context, String filePath) throws MessagingException {
        try {
            if (from == null || to == null || subject == null || templateName == null || context == null || filePath == null) {
                return Mono.just((Object)MailSenderMessage.parameterError());
            }
            String htmlContent = this.templateEngine.process(templateName, (IContext)context);
            FileSystemResource file = new FileSystemResource(new File(filePath));
            if (htmlContent == null) {
                return Mono.just((Object)MailSenderMessage.htmlContentError());
            }
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, 3, StandardCharsets.UTF_8.name());
            helper.setFrom(from);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(htmlContent, true);
            helper.addAttachment(file.getFilename(), (InputStreamSource)file);
            this.mailSender.send(message);
            return MailSenderMessage.sendMailWithHtmlTemplateAndAttachmentSuccess();
        }
        catch (MessagingException e) {
            return MailSenderMessage.exceptionError(e.getMessage());
        }
    }

    public MailSenderService(JavaMailSender mailSender, TemplateEngine templateEngine) {
        this.mailSender = mailSender;
        this.templateEngine = templateEngine;
    }

    public MailSenderService() {
    }

    public JavaMailSender getMailSender() {
        return this.mailSender;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }
}

