/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.examples.chat;

import bg.codexio.ai.openai.api.examples.chat.TrustAllX509TrustManager;
import bg.codexio.ai.openai.api.http.AuthenticationInterceptor;
import bg.codexio.ai.openai.api.http.HttpExecutorContext;
import bg.codexio.ai.openai.api.http.chat.ChatHttpExecutor;
import bg.codexio.ai.openai.api.payload.credentials.ApiCredentials;
import bg.codexio.ai.openai.api.sdk.chat.Chat;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class ChatAskWithCustomOkHttpClientObjectMapper {
    public static void main(String[] args) {
        Scanner console = new Scanner(System.in);
        System.out.print("OpenAI API Key: ");
        String apiKey = console.nextLine();
        System.out.print("OpenAI Organization (Enter to skip): ");
        String organization = console.nextLine().trim();
        System.out.print("OpenAI API Base URL (Enter to use default): ");
        String inputBaseUrl = console.nextLine();
        String baseUrl = inputBaseUrl.isBlank() ? "https://api.openai.com/v1" : inputBaseUrl;
        HttpExecutorContext ctx = new HttpExecutorContext(new ApiCredentials(apiKey, organization, baseUrl));
        System.out.println(ctx.credentials());
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthenticationInterceptor(ctx)).sslSocketFactory(HttpsURLConnection.getDefaultSSLSocketFactory(), (X509TrustManager)new TrustAllX509TrustManager()).hostnameVerifier((hostname, session) -> true).connectionPool(new ConnectionPool(5, 10L, TimeUnit.MINUTES)).build();
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        ChatHttpExecutor executor = new ChatHttpExecutor(client, baseUrl, mapper);
        String response = Chat.throughHttp((ChatHttpExecutor)executor).poweredByGPT40().predictable().andRespond().immediate().ask(new String[]{"Is coffee the coolest drink on the planet?"});
        System.out.println(response);
    }
}

