/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.examples.vision;

import bg.codexio.ai.openai.api.examples.images.edit.ImagesEditCustomMaskFile;
import bg.codexio.ai.openai.api.payload.vision.DetailedAnalyze;
import bg.codexio.ai.openai.api.sdk.vision.AIModelStage;
import bg.codexio.ai.openai.api.sdk.vision.Vision;
import java.io.File;

public class VisionMultipleImagesExample {
    public static void main(String[] args) {
        File fileInputImage = new File(ImagesEditCustomMaskFile.class.getClassLoader().getResource("codi-image-to-explain.png").getPath());
        String base64inputImage = "data:image/jpeg;base64,/9j/4AAQSkZJRgABAQEASABIAAD/2wBDAAMCAgMCAgMDAwMEAwMEBQgFBQQEBQoHBwYIDAoMDAsKCwsNDhIQDQ4RDgsLEBYQERMUFRUVDA8XGBYUGBIUFRT/2wBDAQMEBAUEBQkFBQkUDQsNFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBQUFBT/wAARCACrAKIDASIAAhEBAxEB/8QAHwAAAQUBAQEBAQEAAAAAAAAAAAECAwQFBgcICQoL/8QAtRAAAgEDAwIEAwUFBAQAAAF9AQIDAAQRBRIhMUEGE1FhByJxFDKBkaEII0KxwRVS0fAkM2JyggkKFhcYGRolJicoKSo0NTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqDhIWGh4iJipKTlJWWl5iZmqKjpKWmp6ipqrKztLW2t7i5usLDxMXGx8jJytLT1NXW19jZ2uHi4+Tl5ufo6erx8vP09fb3+Pn6/8QAHwEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoL/8QAtREAAgECBAQDBAcFBAQAAQJ3AAECAxEEBSExBhJBUQdhcRMiMoEIFEKRobHBCSMzUvAVYnLRChYkNOEl8RcYGRomJygpKjU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6goOEhYaHiImKkpOUlZaXmJmaoqOkpaanqKmqsrO0tba3uLm6wsPExcbHyMnK0tPU1dbX2Nna4uPk5ebn6Onq8vP09fb3+Pn6/9oADAMBAAIRAxEAPwDD02ynmuFgt5HnkUbZ5lUp5qg+33QPQ9am1O+TQY/s+nTOskkf+lXk3yhWJwF2/eHbGBz+tXLr7Xcx4jSRRLGwMaMFlK46scDA9Bxx2rAsY9Q0y4gt7R3a7vJNilh8gUDBbJA5x2zTjJSPCnTcSfStMnvGWBH867uGJWNlIKYPLs2AGPpgn6V22m6fZeHnZwkb3W353RWYM46khgBzn/69N0TSYvD7M0c+Wk2iV1XzNrHnPHzIe2MkZqbWtssyteurySDENr5ZD+aD0ckAhsYP3aic+bRHVTpqOstyK41L54oJGklkm+aGOKBfkJ43HC9vXIH865vXLaTUJAD9gvpYyqEeZsbIPIBG51P4kE+lbt5NHfaeLOSRQVw5huInlVgDyFJAXOeDjircihVkaRJWkkUERKhIiIH3uSpwOOnpWd+X1NX72nQwlje0kgghIS6BOBGu6Ij1wSGDjvxzWpqniCTQ4Tomj3p1LULhc3U7Rs32dO5BAIUgdcntxXZax8PJNP8ADthfWOtRz6xcRCS6geIxlkYcYfIDHHOCR9a8kv8ARbhpo4ILqa2hll23rzId7cfKCS2CPbAx61lGpCtLlcttyqtCph4qTi1fZ/5ElravgwWk+zTYT5l3qClSs+egYljj8c0298UPrUC6RZWczW0TjEGzevT778hAAehHHNZmrATQRabaoUjV2RY41O+Q9ydp+77ZqS1sY45I7OIMZmASeZ43YMR2zuwFHXPWvQSR5PUltQtxu0qAqkYYs9w8hhkfJ53MMgKD0ORmrOsalJ4ejW1ikW7ZVwRJC8x54LPwAXx0xyB+dX9Q1W10DTo1hmH2pm3Z3KD5g6P0JKegJ59a5aZtvmahekSXV0pa3U7dhbp8zFiUHsRg1a1IemnUuQW6WdxIkySHViizQxrNho1P8WD3P90Guj+yt4ZhNy0e/WLhQ8aMGk2A/wARIbDN7bhjpisO326HbjUNSDXWoXCkW9lLHgqvdgACDxyB0HoKT7QqjzbqBZGZtsaqjjeW6BFyDwepxV3ctOhFmtyr5JZo547lri4nk3IVI27yeTtySB6jOa9J0lofCGkzajdN9p1eYDBWHd5nOApLggjPfOfasjQdPi8J2banrc3k3wy1tgMpB9FHUnnvx9aqaxqE9xfw3RijN7M+y1hWTEMWf4mJ+7J+AzUuXNoi1C2r3J2vL3ULu6k8yGXV7pWEj+czfYYu6txwe27HGa19PksvD+lwPb2ckodjm2AEnmt2l2gcnI68cVT03Tf+Ef0yeeeQTIr7rkSTGR7lz/Djggjjudx9as2dqZr59cvo5LabbuaJlKm3XOAc7vvH6DjqDRa+4KVnodFcTXEUaSXEjQTyYjLxhiEJGduTkH1JyMehot9S8yCOKHyYE3lFy+UBxyDtX16buuTXIzZ8TaosNlGwS3UqIlYBY4+7N02se/1HNdLba7Z6JI9ragT/ALlUZzICQRwBnHP0rKVF2vE6YYlbSLbaToDsWbUrlWJyQBGcf+O0VlN4ptoWMf8AbEke35di6pgLjtjHFFT7OZf1iHY5i5hS4W6nkikvIx80yyqCp29MEbeh/ugVzd7qdxrM5vC5+zpJsiZ3MbzDg4KBskds8A96kl1KfVljd7SW109ZCgXywGlbHGVLBsdsgZx1rQtdFNqxu9SuJbMqFdbWKdXjiPYqQBx7knHpWEI21ZpOfNotjZsfPbToLu5hjMycKx87AYH5VySAevfrjqKUXUd1JJG4uAWXaVspZBuHoFLZCkjOSfXFcVcTXXjbVmuZpZDptiGVmTBKr6feztz6Z+ldnptzFp+2BYLnfFErwRnncCOXUjOR6jg+xqpR5VfqVCfO7MUvJFLFMqIJssYIwCZORySOrD8z71Yg827aWETxG7ZDvaPdt2n09Px/+tWbqV644RmacEsZXUBEB/8AHgfypdNka0hijhRMP/HIzls9dzE8Y9FwD71zs6+U9v8ACepCbSo0mEc8YhQD5eMAY9MYrE8UeFYtU8y509lNyV+QMgYP/skEdcdD+BzWRpmuS6bHp7vCxYJtkZWAzz7cHiuztdS0hlMi3LDIy0eMYPr/APrFfL1Izo1nOm+p+mUlRxmBhSqrovl5nhGqeHFt5nZHW2vXXZOyny8JjgLjhD27VV+2WnhXT9009nO7qDtnP+sKjBAYngDv1z717t4k8I6ZPaya0oceYQtytu/yjPSTaD0PfmvNfEnw/wBE1OVZF15XlT5mS4RlDf7Dfeyn+ea9mjnGGfuVJWZ8LiOHsYm5UoX9DzUXUjBdUvHebzCzRgt80nGQvPO0DpjGPercIhjjj1bU5bhIWx9nhjUZaRec7iOEHuR15rcj+GZa6t7xNct5Xhfy0tNzLEVJztDYGBVrxH8OfE0lwLpo4pofM3RR2Vyhij7EgfT/AOvXpRzDCVPhqL7zx6mU46l8dF/ccfJcXl/qnm3CrcW8ku5FhnQMD12KB3HfbXb+DvhzqM0Q1O6gjedeE3SSPCsfbO4nn6f/AFq0PBng+3+3IxRpgnHyjIP+yMdvfvXvOn6fH/YM6qqg+XtWINjb+FeRjMyktKGi7n1+V8O07KrjFdvp29T5t1bUJDfv9tZs28oSzs47kITIP48D+E+hqWFprdb3U7157h9m26kjiWSQ/wDTMA4yo4yfana9G1v4s1hp4mlbcVyT5apGB9zdztJ65xyKx4Taa/MGiiNvZwkRqp/dtLJjndnOAB/FjHuK9+lJyhFvsj4XEQjCrOMdk3+Z0OnKPElzb6pcxtFbbd9pFcN5KhFHLgqAcDGdvDDtmq2uX66teWlvaQMkiyZiaOVpBLnPznI9OAGAIHWqGsa1b7pLe1uI5HU+TLLAw3TuMYzjjAHQjOahk1a48I283mxNealfADz5LjDW390OpTbj/aUtiuq73ONxubd7JH4chTTLJVl1No908u3zE2nr8wHOD2z1x2rNjkm1eZLLTTLBHt2SSlXVkB4JZhzknjI6YrEuJJ5rq0eKK3uLyY7/APRwzFyf4uAQE44wQCRWn/bsXhy0lsoJ1Ms4/wCJhKkpkeEH+FG2LgnoevWqctLE8vU6ddN0W2UQtLqjtGNhZEypI4yCWzj680VzMemzvGjRx6h5ZAK/6OBx2opfMsrLbzSWa6tdfaI7XKtts2DpHg4Jw23GRgnJyprNa+ufiBqH2c3Y0zSE3PujGUO05IGSck9STjrSN9q8ZamzxGS1sQrNJIIdzOobDbF4zx/EmR+NdBYEQW8dnCJHSEkxxNuiLoOkqgIBnnlTzXKvdN/i22LNvCsNtY29tF9qUPtihhG8MccMp5wfWM4rQutSg8HW4eSVrnX5GDxWsyfuyzDOVRSdr+x9OlOvdSt/BeijUb6MS6pKNkcKgFuTkOVC4yPUfXmuGvNS1C/1aYtNJc67cghpF3EQxn7uMDBOOrDp6VhrWdvsnQ2qS8zQtLy4m1NovMkvriZS10WciFFYncuE6Y77vpit7Tbi101G8v7LcpLmBDblZS7jnJ8wlj65A47Vyt1rSeDgLDT285iFN3eLGDk/xKpPy59xzUuiLd3WqW1rGGk1O8Ijt/LlLRBCeDIBgbsHuSa0nSUlpohUqzTs9bm9rt9fppb3EuoxSJnKmYRsFAGAFIXp+Vctba1NdQRq0pguGPmJsb93J/uknr+OD616t488CReHfDN1pl9ewXeruyuRBEVjXH8OSxJNeb+Ffh/eahP5MlnKdNZ8MBHkc/xLjoR7V83io+/ofoeWVJRoWZdi+NtzpLwaeytced+7aMyYD4H8Wf5V3Hw58M3HxW8WtA9m0ds0Xlo/IX+8cY/nXN698LbPRtS0xLtt1xLKY7eRsfvgwwPxFfYXwB8M/wBk+G7a4YKCqMmCMbjnGR+FeFDC0qta9j3KmNqUKLa+R8eapq0fhPxwui31rJZRySOE87oNvQ571ur4xhtob2zzFcvNgLdRONoj9gOh9a9T/aK+HsGqa9bXM9tGlsCzLMB86sT2PvXhth8NbnwzbNIjmT7RMxGBnjsPbjvWEsHGFS8XsdMMW6tJX6nWeA/FVmZdkpWKNTjd5qD+ZFez6NcRaliVbqynto13NuKsQo56jIr5p/s97G1mJjZ7mTIWOAbR65JPX616j8N/C9/42+GWtRaRDPpmtsNu6F1DGPPzHc3t2716lO1SUYkV5eyw86q6I8x8aKPEHiS/t7TyLS0juGe4AcnzmbooG3P5DFZmuaqbaA2qp5PloI5VSI5wOkak7Q4x1yCR0q34jvG8MRnTkWN54siaKSTEttg43khdqs3r83XpWBbaYlpENSuLeOCOBh5UPmgNIx/iYgYIA7gj2FfcxVkj8VlLmk292WtPt4/DEL6zdwBbiVAtvGhUbOysASQD9eB3IqpNcXamSa4i+0zyDy2bzPKkkGfuKMgsB/ER+vWh7q71zUDdXKWs+4FRFIzBunZcHOR3z0robT7LZGRZIzJdlVKIAXSMAdeVUgL6Hd1/GlKpy+pUKLqa7IZp9jc+GtNYS+UdbvUxFjlVjP8AE3Xt7jpnFZ/h7RY7YtPJNDJEreYrLKG3HODJ7qD68k9qvpo9xqF6puUkEsuXeFeW4PRS3XPU+lGoXSaleNp8E2LWMg3ly5AiTnhVC52n3JH0rWMk0YShKL1RpN430QMQT5hz9/efm9+DRVlNLhRFWPSC0YGFZ4VLEdskP1op6EGZp9iunWdvZWkX2xWjbyXAaMynruQjBVsfwn5T2rQlm0rwXY/b9SlY6tOqtBG5BVs8DeNhCtngc8mmte2fhbSzcXphN7dBpLSGKRSCf4NyjPSuFl1LUVuvOuVkvddlBaOTzmAjibhvMwDnIPbpgVwO9Z2Wx3aUle2pa1C+1O41CWS7aa81+8hbMmxttmv91htx93HXp71Ujjh8K2YsrCZZdS2Za+dGlWPJ+4CSODnuMeuKfDHD4bspo7eZTrboZDd8GS3UHB4YfMccYIBqvbyLcS2cssYjZ/nt45HZXlOP9YwHB78AjGccV1RVlZLQ5pN7vcbZXTWbo1xbSPO+RFbxnY0TdfMYchjjNb3gaG30zUodVeYTyJIAHWNlUAnqcNlW7YxVCy0UtbrfahJ5eJdq749iHH96QH5SD0Unmqd9qdz4jvg2neYI42xJJJCoMijnzGJBzjHGM4qnroKL5Xc7Xx5qD+M/G9vpQuXFux8yYxKWYj8O1enat8SvCXwF8Hg6rBcK8oAjX7M2ZT6DqM/iK898OaX/AGL4qtNUaYSxzWyEEsWyfUMQP5Vn/tI+HL34reFfK0992pWcnnQROwAkGOUB6Z9K+flQUm+Y+5pYn93HlXQ53Wf2ktE+I3jTw7rOnh59P0l3EttIu2SCQ9Cwz+tfZ3gf4uWDeEbSZWwFCk4wOvOa/JX4P/DHxL4b+KFkupabqFra3FyyXck0BRAhB4OevOOlfoB8OfDt1cWrwRZEMTbcdcjtWawkaXwM1liZ10lM9C+O3j2wm8P3V1HdLLJD5TpApBJBIGAPWu4tfBlr4m8NWVzBAqySW6My5BI4zivjP9qjUp/hro9rexxrNqF5OLW0Eg3KjdSxHtXmv7Mf7UXxbl8bw6RJrV7exS3yWsNpPCrxMpPIVccY65HSuZYL35VL6Hb9c5YQpJWZ9g+NPBUei3AlkjCxg5bIOD+XWvU/gHdaNYWM2nJG8c90S3nSDAOe2K6i6023vLSJdVhjuTL8pnRQMMfbtzXkMdjd+DfGclqjmS2abKA/wc9q8qtCthpKpT2PUhVpYulKjUdmeS/tLfDO98E/ENtT1VLYaJMPNhKzu28k9mYEhv8AZzj0rzO71geI5IZ4pIFtrXaqIzNGYxnIyjLtIHbI69hX6O3f2LxV4XurLVbO3v7XycvBdJuXp15Bx9cV8IeMvC+k6P4g1J9JWSLT4GY28AwgQjqEbJVhnuADX2lLEOUFofnGIwihUbvoVLBYY4ftryu8rLsijW6VxtzyCX4J59cjtTY4rW1k8+5PmozkysrHc5zwQOhHuOe+KTS7g3Hz33yQquJGkRSFHUrkcDPUnJ+lXrmaZXheaOFY8fuYWLMuMdQ3Awf7vOPSl1FsJqRa3DvdxSyTSjo2N4X+Ehtw3ducfWs7TTDCreRaR3FzE7SERlQAWHIcKTkj8z61t3StYx20zmTMo2pGm1Oo646ke5HFZUVrLdXL20En2crkXE80gczA9AVC/N/P6VSdtjNpPcj/ALB12b942uSIzfMV86cYz2x5lFa4tIcDJAPcG5bP/oNFbe0Zz+xXc4nVNW1DzItSu0S4v7htsKSFmSFT/EdqkMQPpj1qC60f+wfMlkNvearKN0sjOQYUIzuCnhxjsBWjHC3h2G6d2W51mQ+Z5ks6M8PGTuyR1+vP14rGhmlFmupailybMuN25HD3DdMhuw7YJIrRK2i2OXmvq92VYreK3it7ySJmgZmltlfaPtDdCVyq8d8Z6etXtDs4dUmnubsyXVsjeasZf5CCO7Z+VFI46jPrUtnbrrMrSSK0KqxWONApY8ZwvIwvT5h6dKpeIPEF3fSmxsicqoWafYEWQjqo2EDHv1479aevQXmyXUdcn8S6w1hp1xJLbylQ32jypHkx13bUzx2yce1GntMt9DpGlLb3O6YCe8aEibg84OSNme+M+lZ5kO37DbhXvJD+8mVgzbsYxGc4+pzj3rs/Ds1jaXVvYpKsnnMpneGMRyEA/wCqUnPAPcDHuapyUUEYuUkdvrf+jSwR/NuhRQTjrx/KooL6JJg0oG09dw/lV3Xn866dt+weijJ44Fc7Hfsl9DHK0jwbuQeePpmvIk7u59ZTVoo6xtNsb63aaIRqcZ++CcZ7A19D/D/wbpltpcSRACQxiRZm5JJ5r85PEw8SaX8SL+exu723unb/AEeQkGMKem32I4wa90+D3xe8cWWp2litub7U0bZd2t1cFYLdcf63dtO4d9oI+tc/tL6WPXp0bq9+h7v8WPg3pPj7TbhNQtYL1M5VJhlCB1+h+lcv8Mfgj4b+GN8l1o2hWdpeMuFvNzzSbT1VXdiVH0xXZR/G7Qbq8i0GTU4bu7kXy2mjCR7Zj1UIWzj86fd6onhmQQ3VxFvHzAFccevAxUe0UrpdCZRlGza3O1nunksYYACGLBtu7I+lYesLBN4gF08W9sAe/HFUtF1z+0rhZjL5sO7h43BUfka3IdL+3XmJWZJF5UnkNnuDUP3jNNx1R1Xhu+AtJt7tDGy48wNtI/GvlD4/Wsdv4qmH2fcp+aC4SMRyF+6t/Cx9DjP1FfVr+G31DwxfQpH5iSRsrDp26ivijxHPf2upTWuoTLDNZExpI8gPlx5IBA7sRkc4x2r0sPHQ8PHVHHYzrFXiijW6mcEEbo1G7ce2cAfL7jHvU1xMWaJjayKqynyl4Yhv9k5P8x6VkW7HVpElktlEakxQwZYhm9RjAP0JNX/7QitWfZcM/kkBJsARhu/XJ4HH8VdMo22PMhU5viLtxeoLUQySyRX0hzN9pmSPA/uqD6j/APWTTJLWGTbYQqjHAlcxpIRt+g6cepA7gd6WHVILFXtoyrXdx8zFtiqyn+IHPXPQ/pVSOJLpktbaaWO1V99xIWb52P8ACfl9euCKzRtsQSahYQu0YWbCnaP347fWbP50Vt/Y7VflM18pHG1Jyqj6DbwKKoi55/8AYHLSTXTSJp6nzAqqwads9VBTGfXk4p1roEl7cyXV0jiHDAGVfllwOinDFR6k/rUHhDXNO+IC3MtxdtZNYr+9tLgMHhzwEwAMof768fyq/q+uKrTWGnQxPcFRGHiDAhcdI2XofUkZNdh5autzJ17xUJYf7P0tjdKwCO9vGY8pn7qcYKAnH9BVGL7PpVuun2qR/wBpu2ySbHTJxsQ54PvxjvzUWpXDeHwId6XWpMQwWQjMCkYATJKknr7VXlnXwjYMwit57ycAiYL54jU+jLjknrzxRstClqdfoOiWC6xDp51uSxvrtTBNcvbtIYRnJXcNxC+p/OvobQ/2c/C3heyh1m41m+1q82b1dZEERY/x4C9ffNfLHgXxBZad4ps7/UJi0gkC/aGZ3YMTnaUGG2emCfoa+zb/AMVJqfh+3lW5X95GBsjYsv5lVI/EVy1pOO3U9fCQhUV2jyHxZJbafcSG3RxGOS0jZzXGRX63EYdz88h+VVGSR6mvRdcsIboMHQSNjOMZNcNqWgz72eL5GK7QBjgV59z2YrQyZtQW6vo7cSWi3UZzCbqPcPp2rR8N2fiDStdu9RuLqK+SfaDb+WIlTbwNhHT8c1x978Oru+vHlnkcFR+7ZTwuO5961tM0HxhsWI6rJFYlcBmUGTH17Vm3Y7aUuXQ9YsPEfhrw/q39qX2kJHrAHmBd4y59eK7iPSrz4jKdWu3eGMldiN864PTAPKn3HP0rznwL8KI5CJ7yZ7+6lIzO+XP0P/1q990WP+z2+xXFhc21vGBtcpweOprnbXQ2d3uP8MeALPS8+RG0czYbqcOR/Wuz0tF3G3mBBX7rHGRWP/azWM4jjEksaKCjKMZH+NPhupryVmK7A/BZh09we1JENaHo3h+48lWjADxNwa+IP2htBTRPi5q6b0tdNYrcSFozhmcdGx1BPQ819s6Bp7eQu8sxU5KjqfevDf2rvhDqN3Yp4u0JxctbLtltZskwgnl4/Ueqn8K9DDyszxMbDmifI19qk8cktgIVhMifvpGVkESfwgdN3+91qXw3GmpSIGlksdOgHyqVAErDnc2AT9CBzUVvp512abTht+yQNvu7naFV89QjenqDjFSeINaSBYtB0wotkibzMxGUA/hBBLfr9c16nL0R8/f7Q+98SRnWJjZhZYW+QmNQVc9yAFAPvxk/Wuh0W1TVAkWnsWedcmQtLGAB1fcW4I/I9K4LT7S58QapBbwERW+3aY90m8AcgkgZQn/Jre1u+l+2JBYQxxWVuuZ5tik5B5ZjnI9uD60pU76RKjWa1lsdg2m+HYWKSRRyyL8rSOzbmI6k89TRXKxeNNGjjRTHKSoA5XP67KKj2TNvrETxi80m78O3A1DT7s/Z8mKK8s7siSMN/wAs1yTuT1U9at+G/HEMMMsF1btaakziNLwZa3fn7oZuVY/3D37kVV+03vh+6nt5ollSZCJbOZROrLjllPTI/wA4rOv9Lg1TT/tGnTxzYO6TSpXCnjgsW5B9gCM/rW9zltdWPQ41tfDt61ykiT6nJGfLTHMO4cgsF++fX8q424uLu58+5uPMuZHJDLEuzee2Odw468AH3rmLPxBPp90Yb2WWS1hUHzNxMiL2Xody/wC0CDjrmu48P2tjqEcmr3sUL2sn3DbyjbtHY4zz+f0pXtqxqL2Ro+GdPTRPK1rUL2QXvVPOBcIB2KAN29cYr0vw34t8VaxM8n2rTf7Jz8jQs7M490CrhvwxXz9rmrJq17NEs6HSoyCpZGJkwfT17ZI59K+hvhnY2CeF7WeB5JpJ0x5gZvL+m1iWz+A/CuSt8Nz1MKvestjoV8WssMomkhEiDLF2Ear+HUms2DxLDIskkskSE/xTTHH4DGa0h4SElrPcpb+aI8F1Vd5AJ64Gc/yrU8O/DrVbzUCsFhPJEyblnjgUL+JPevK1ue+oqw3Q1j1KNGhUzpjhyML/APqruvD+h7E/fwuJFbHyrkV0/hP4e3GmtGl7aCFv+eqEDj1wRg13Vv4VktWZBbLcLuDB4nMbY7Hrg1LNUYPh/REmt0eJ9uDgsXXaD9DXTrY3MNzC0qtKp4jljUMG/IjmrltoVujM8KSW13GdxilI5H49fwqaGSSGR7W6jzaTcpcWzcfXae49qw2NOY0bPS4bmPc6LnpkAAg1o2+gJyAMN2qtpontpAks32lO0yDII/2hW5CqxsI33KG5Vgcr+BqkZNvYh0u2ns5FCnIXgp7e30rT1m3ttZ0q5067iWWG5jKMkgyrAirFuqs4Dff7Hsfxpmo2JkUMjAbTnrXRDTY5JNSep+ffxk0+1+Gc17o2jb8b2UxM5cwE9ywydvcc4rxO3tZrqQxwB7iaYkidt2Xcc7mzwceor6H/AGoPhj4p8P8AjC98QCBNS0W9YEXEaktCP+eTL3BPc5/CvIYdHm8OwGea0ke+vv8Aj3V41X7OB35bOK92m04po+XrxcZtWsivdZ0qNNG0pJjdzHFzKCcrkZIXB5B7nkVBFuupINK0pA7SsDLhQQ7egZR93HYgDPaoLqSPQ7JooHabUJgfMdl5QMfug5OD6nArWs7K28P6bPLPDOJjtWSHBJDEcp8u088ZPOBW6XKcm+5of8I7JD+7a6AZflIB9P8AgFFcw3iHW8ny7mSKP+GNRwo7AfP0FFHLLuHu9jjridNXYQXtu8EyP+8TcVwx6SI/JXj+HofWuX1aK40m8W5triV5I5PK8yUYDN0UMTnafTnFdP4ithrEKXMtwqeWMx6jBgMpHGzYTzjoeePTNYcWoSw3kkGpzRI+wRC/jG5GQ/wHaxG0/XIrFM6DW8E/C/Xfi5qSQaNpvn6qpbzpUxGoOepIAwB3wSvrXqGqfsHfFDR7ORtO1LT7q2lJkuLG3vGhEp9gAArfQ819Mfsm+H7TwP8ADHT7eOwt4NT1J/tNx5KkEKfug8knjnkgV7jqUc7RmSJ8L6lTivPqYhqXunuUMHGUE59T4D8N/se+I9W8mPV9PW2CNsS1ZlaRD/fDJww/3ua+o/hz+zV4d8K6FDaapNvn2gTbMYYg8ZcfN+BOK9JsNY+xyEeS0bHlplYSIf8AeA6VYm1KzuSytILhZFyOMD/gJNctStKR308PGGwmj+G9B8PswsrOKCRl8slDndjswNa8c0agqkS4/hYLt/D61wWseJtI0S4Q3lz5aAbQ0q9B6E8frS2/xN8O3sYVb23AztI81Rz6dev1wa5XPuzuVPtqdpcTruUY2noASAKgLM2ditEoyHMbAj8u341jW/im0uGEcF2jj+674bHoRj/GrUuoIqhmVenClsgj2I/liovfYu1tGblsyt5bghpI/uy4zkeh9auXNjZ3sLZxGGO4hem71GelcXHrFtHcYjiaJj0+XIPuMCtW31bflQ6lu7AFD+Of8Klsnl6mtb6H5MuY2MyKPuo+D/Otuzb7oZ98Z4+Yncprk1vpGZ4d5WbgBhJkfrWtpurlC8UoOF4bcc5qVJXJlFtHWRyKsZVxu7gjg/WnR3e5myu4HjB/rXNS3AZvkyH6nH8q0LC5OAHBZuwrojPU55U0lcn1HTbDWhGlzbrMIzuBfOB+HevH/i58DbLxYPttq0drewnfHIUz82MZOOenTBFex+SdwaSRUGeUXmq91IlxlFUY6V2U6jjqjmnTjNWZ+furfB6XwMtxfaizXF5k+VtjJVPViScMceucV5rqN42qMwlUW8MJYeWzqrYPb73U9/avu342fD3T9f0VzqL3At0IbyYJhF5hHQElTgflXxT4is7MalFpenaebTy3byEmlDKeeXbMZDfWvYo1PaK7PncTR9k7LYxlvtTZVMX2RIiPlVQmAOwGaKuyx6Wsjq96JWBIMm6Vdx9cBeM+lFdGpxHniag4vpSfJiulj2lJ3DNJ6fNnDZ+oIrHa7t2j2tb+a0I/4850BaHnJYMB8w9ieK07i/svHEcY+Y3artVsbZIwOp+Xqc/SuM1SOa2zb6kku2N/3V7GAOR0LHJx9OM1yI7Eup+iHwX8XW+qfDvQkS4Z12DeynG8jjHHJP1r1i61S60vw6RfuEkd9scych1Pb6ivkD9jnxtC2mXdnqknmC05ibj5hn7xxj9K+mPF3mazpdosfmm2C+aBsO3mvJqRtJn0tCfNBBbeJWglkgjeNgP7xOT74BplyxvCXW5MBjbBR8Kce2Ca4HTvD1zJfHy5fJIO5XwD+GCOKi+IVxq2lxxXTkBSApZsHcB+lcbep6UVZGZ8crrT7G3YQ6oi6gsYnEbMFDoeCT0r5/0fxdosULanYm7i1BCRJCuJ4nHcBcEn6jmj4hatZeLtSc3yrO8fyRFM7sDt9K84uNLTT8x2ivEjdUibA/Gs5UebVm8K/Joj3S3+IWia5aRXFtOILqADbC6kjPseoI9jXsHgv4nXV1pQEix7l4RyTk/XPJr4otluLeWM28rLJ6DnNeieHfG3iH7PDDJbeYo4342DA+nWphS5GOdXnVj7Ht/EVxcRiZ0j2L8zJI/b1Gc/zroYfE9nDHD5E7TzSnaIom3AH64r5k8M69PqRtkljuEwNkomcyKx7bVPT68/hXqukWM8ljHdz3TW1rG2JRAmAzDomc4J+nSnPyM4q7PaNN1Q3jIjDznU8c5CkdTn0FaX2pmLOksaovXawyB61wum3rNZ24WJoLWVSBh1UhV7sSe9dJpuvf2YGEkifZmwgWNd6qPU46/WsfUtrsdbpl8zIMjg+o61tLMdoYHHONi8Vy1nNHMGK3yTsTncFOcemOw/Ctq1uGkj8tGCZ4LdTj0FdENjjmbnmb41iDZI5bHb2qPy2Rs5x71TWGWHAjdXP+9Ukfnh90oP511J9zBozvE+gw67YyQzO2xhhuP6mvjT46eF9L8N3zWmlRXA1K4O0Klszg47szjAHfjAr7paHzrckAr7187fHzwGb+xmk/tCZ5GyAvl79v0b+EevU120anK9djz8VS9pHRanxiND0XA81Lt5f42GACe5or0qPRfCNqiwyX0/mRjY3zdxwetFb/XJfyM8X6qv50fIV04+1PIi/ZpMYMksRJb2b7wH1GBV8+LIbjTP7LvlbeDvLqd6HsNvXA9eRUV8IdYti9vKLS6VTiAEPk4+bYB29jzXDX371kSUbNrEhWyhX3BOfyzXXZMiN7n0b+yhbzQ/Fi300ThtHvBh2PB4+YgZPPtX3hqXiSxvGaK0hZYYAQZcckgdOOMV+bP7KfjaHw38Uke6kaSNLSYQMzZCyEYGfevsnwD4sGvaxExn3RCTy5IyeAp46fjXl4pPmPocC1yanomk+JraOYyz27Rhh96OPsR2ryr9pTxgNJ8LrPbk7bl/KG4Y2jHamWfinW7nUNR0+1syXt5JF38bWUEgEdzXjn7Qt9c2PhOxfVtQ8yae6LKpbhSvVQO1efGHNI9aUkonl9nqktxdcERRyffkY8n2FbE1xD5YWMeeenfFcv4blg1CYO52qDgHOR9K9v8ABunt5KGG3tNTgPULIoZPcAjr+NdLjY54O5leB/hvd+KryGcRvDZRgea6x5H0ycDP517Bb+EtPFwYfskjWsOA2ZhGgPuQMn8cCum8OK15oyxWl7DplzCw3wOqhZl/2WOdh/MVt6H4KR7xLma3Oo7ZS6RGQtEpHcnPzn2GBWDOhbFK30uLS9IeGytWiuZozNnkGOIcbgP4c9s123w20K2bwysF5pMcckj+aqbmOwDo55zk/Xmo77UpYrg2OnadCt1cyKZ5rtd7uR0GOmB2HSt7Urma4ZLSH7UUhwZDE62yFh1JbBPX6VlLuXurHJ3Hm3lxeLLGrtC/yWuNu5Ae3qTiu/sL/wAhLeeSKTT90YVoSwViD6gdPrTmv9OuFjuLuO1LrhfOYENn1J7/AFqG+DxtbpNJthz+6YjeCD7+lZcttUXzX0NSG3s7ebdHLKoY5DN83/j2c1r2+oRqMMysV6Mp/nWAtqkMe2aPaynAaPA3L61XjtBFqMUiszQnJIY9/pTu49CbKWjO5h1csNsSM7+mO1WbHWBdfK7NGwOCCKZpSw7QFKgjn3qW9s2jXfHtdM5zt+Yf410JStc5dL2sbluyeVjzWk/4DXmfxe8L3WreH757KFjcMhAw7qTx2K85rs7GS5bG0CQe5IqTXY7ibS5ld3tMr/r48Nt/MEH8q6YO+pzzjuj85p/h7qazyB9Nvd2453LOTnP+9RX0de2uy8nUXyyASMN/+jDdz1/1dFenzHjewj2PywvLi2uWEaFork8hZR8sj4xkEdD9KrX2qQXtmlveyskysQMJjbx1ZsdK1fiEotNSvUhHlx5+4vC9B2rkbmMTaHPcOzmaHiNg5G0emAcYrp3OCLMm41K98P3we2uGjdfuyQttVgPX2rp9H/aW8Z+EtQkudPv0ZpYfJeKWPIY/3gRXDQ3UphlQtlfQgflWJH/rJX/i37fw9KxnbqdtGT6M93vv2tPFknhdDa3y6frMdyCZrdc5XGTgH1715z4u+MHif4nNbJqt4H8iQuu5tgZjxk++OK40qFYkZzg9667wPYwX88a3ESyDHXGD+Y5rFRjFaI6vaSlo2eo/Cm3u47eBZLm3m28mNXQtk++c17tpimFVmti0Mq9SjZrznwT4c02y8jyLRI+cnGf8a9o8K2MEN3GUjUb5FVu4IJ5Fckzvp7Gl4f8AEHzCS7uJIypwWVdxb2xXunwx8WRLHBDanZbg4ZWxkH1I968gvtPt7LULuGCJY4o3IVeuKl8HzyW+txNG7Id4U7TgEZ9K5mdkXofT1oz28huV3y7jgtjoc9PpVbxI1zrOpWqXEE+n6dAwMnkg/v298VX0i4kS3fDnl8etdRHAk9hbyyAvJMhWQkn5hWLiap63M3WVtm05ooUZ4o0yV8zccenP9Ks2LJPb2TMvyKoEXOVxj7vsa5y4G6QKSSuOmT61q+GmL6bOjcqr8D0rNbl9Dp1tEuGjjZvLITcm88kZ5/Krc1n5MYV1+6OPcetVEYz6Tuc7mUEq3cVJZzPNpse9i31rWxlrYtSXD28ayA4QHacV0WnyPfWP7t8Sf3z2rBZQdPlyO4q1ocrq0qhjtz0px3IlsaMkWo2fMjeZH6qTV+KaaS2wNsZPRm5U1Qm1C4jX5ZWHz4q1o8jXDypId6kHKnpWsdHoYyTaOSudFuWuJSdF0yQlydxj5PPX7tFTXVxNHcyos0gVXIA3npmiujmOXlP/2Q==";
        String response = ((AIModelStage)Vision.defaults().and()).poweredByGpt40Vision().maxTokens().explain(fileInputImage).analyze(DetailedAnalyze.HIGH).explainAnother(base64inputImage).analyze(DetailedAnalyze.LOW).andRespond().immediate().describe("What is the mood of this picture?");
        System.out.println(response);
    }
}

