/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.http;

import bg.codexio.ai.openai.api.http.AuthenticationInterceptor;
import bg.codexio.ai.openai.api.http.HttpExecutorContext;
import bg.codexio.ai.openai.api.http.OpenAIHttpExecutor;
import bg.codexio.ai.openai.api.http.exception.HttpCallFailedException;
import bg.codexio.ai.openai.api.http.exception.OpenAIRespondedNot2xxException;
import bg.codexio.ai.openai.api.http.exception.UnparseableRequestException;
import bg.codexio.ai.openai.api.http.exception.UnparseableResponseException;
import bg.codexio.ai.openai.api.payload.Mergeable;
import bg.codexio.ai.openai.api.payload.Streamable;
import bg.codexio.ai.openai.api.payload.environment.AvailableEnvironmentVariables;
import bg.codexio.ai.openai.api.payload.error.ErrorResponseHolder;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public abstract class DefaultOpenAIHttpExecutor<I extends Streamable, O extends Mergeable<O>>
implements OpenAIHttpExecutor<I, O> {
    private static final MediaType DEFAULT_MEDIA_TYPE = MediaType.get((String)"application/json");
    private static final String CAMEL_TO_SNAKE_CASE_PATTERN = "([a-z])([A-Z]+)";
    protected final OkHttpClient client;
    protected final String baseUrl;
    protected final ObjectMapper objectMapper;
    protected final Class<O> responseType;
    protected final String resourceUri;
    protected final boolean streamable;
    private final Logger log;
    private String currentExecutionIdentifier;
    private String formDataMimeType;
    private String multipartBoundary;

    protected DefaultOpenAIHttpExecutor(HttpExecutorContext context, ObjectMapper objectMapper, Class<O> responseType, String resourceUri, boolean streamable, Class<? extends DefaultOpenAIHttpExecutor<I, O>> currentType) {
        this(new OkHttpClient.Builder().callTimeout(context.timeouts().call().period(), context.timeouts().call().timeUnit()).connectTimeout(context.timeouts().connect().period(), context.timeouts().connect().timeUnit()).readTimeout(context.timeouts().read().period(), context.timeouts().read().timeUnit()).addInterceptor((Interceptor)new AuthenticationInterceptor(context)).build(), context.credentials().baseUrl(), objectMapper, responseType, resourceUri, streamable, currentType);
    }

    protected DefaultOpenAIHttpExecutor(OkHttpClient client, String baseUrl, ObjectMapper objectMapper, Class<O> responseType, String resourceUri, boolean streamable, Class<? extends DefaultOpenAIHttpExecutor<I, O>> currentType) {
        this(client, baseUrl, objectMapper, responseType, resourceUri, streamable, LoggerFactory.getLogger(currentType));
    }

    protected DefaultOpenAIHttpExecutor(OkHttpClient client, String baseUrl, ObjectMapper objectMapper, Class<O> responseType, String resourceUri, boolean streamable, Logger log) {
        this.client = client;
        this.baseUrl = baseUrl;
        this.objectMapper = objectMapper;
        this.responseType = responseType;
        this.resourceUri = resourceUri;
        this.streamable = streamable;
        this.log = log;
        this.configureObjectMapper();
    }

    protected static <T> T getField(Field field, Object obj, Class<T> type) {
        try {
            return type.cast(field.get(obj));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public O execute(I request) {
        Request httpRequest = this.prepareRequest(request);
        try (Response httpResponse = this.client.newCall(httpRequest).execute();){
            this.throwOnError(httpResponse);
            O o = this.toResponse(httpResponse);
            return o;
        }
        catch (IOException e) {
            throw new HttpCallFailedException(this.baseUrl + this.resourceUri, e);
        }
    }

    @Override
    public void executeAsync(I request, Consumer<String> callBack, Consumer<O> finalizer) {
        Request httpRequest = this.prepareRequest(request);
        this.client.newCall(httpRequest).enqueue(new Callback((Streamable)request, callBack, finalizer){
            final /* synthetic */ Streamable val$request;
            final /* synthetic */ Consumer val$callBack;
            final /* synthetic */ Consumer val$finalizer;
            {
                this.val$request = streamable;
                this.val$callBack = consumer;
                this.val$finalizer = consumer2;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                throw new HttpCallFailedException(DefaultOpenAIHttpExecutor.this.baseUrl + DefaultOpenAIHttpExecutor.this.resourceUri, e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                StringBuilder content = new StringBuilder();
                ArrayList responseContent = new ArrayList();
                try (ResponseBody httpResponseBody = response.body();){
                    DefaultOpenAIHttpExecutor.this.throwOnError(response);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponseBody.byteStream()));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if (DefaultOpenAIHttpExecutor.this.canStream(this.val$request) && (line = line.replace("data:", "").trim()).equals("[DONE]")) {
                            break;
                        }
                        this.val$callBack.accept(line);
                        if (DefaultOpenAIHttpExecutor.this.canStream(this.val$request)) {
                            responseContent.add(DefaultOpenAIHttpExecutor.this.toResponse(line));
                            continue;
                        }
                        content.append(line);
                    }
                }
                if (DefaultOpenAIHttpExecutor.this.canStream(this.val$request)) {
                    this.val$finalizer.accept(responseContent.stream().reduce(Mergeable::doMerge).orElse(null));
                } else {
                    this.val$finalizer.accept(DefaultOpenAIHttpExecutor.this.toResponse(content.toString()));
                }
            }
        });
    }

    @Override
    public OpenAIHttpExecutor.ReactiveExecution<O> executeReactive(I request) {
        Flux lines = Flux.create(sink -> this.client.newCall(this.prepareRequest(request)).enqueue(new Callback((FluxSink)sink, (Streamable)request){
            final /* synthetic */ FluxSink val$sink;
            final /* synthetic */ Streamable val$request;
            {
                this.val$sink = fluxSink;
                this.val$request = streamable;
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                throw new HttpCallFailedException(DefaultOpenAIHttpExecutor.this.baseUrl + DefaultOpenAIHttpExecutor.this.resourceUri, e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try {
                    ResponseBody httpResponseBody = response.body();
                    try {
                        try {
                            DefaultOpenAIHttpExecutor.this.throwOnError(response);
                        }
                        catch (Throwable throwable) {
                            this.val$sink.error(throwable);
                            if (httpResponseBody != null) {
                                httpResponseBody.close();
                            }
                            this.val$sink.complete();
                            return;
                        }
                        BufferedReader reader = new BufferedReader(new InputStreamReader(httpResponseBody.byteStream()));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            if (DefaultOpenAIHttpExecutor.this.canStream(this.val$request) && (line = line.replace("data:", "").trim()).equals("[DONE]")) {
                                break;
                            }
                            this.val$sink.next((Object)line);
                        }
                    }
                    finally {
                        if (httpResponseBody != null) {
                            try {
                                httpResponseBody.close();
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2;
                                throwable2.addSuppressed(throwable);
                            }
                        }
                    }
                }
                finally {
                    this.val$sink.complete();
                }
            }
        })).share();
        if (this.canStream(request)) {
            Mono response = lines.collectList().mapNotNull(list -> list.stream().filter(Objects::nonNull).filter(Predicate.not(String::isBlank)).map(this::toResponse).reduce(Mergeable::doMerge).orElse(null));
            return new OpenAIHttpExecutor.ReactiveExecution((Flux<String>)lines, response);
        }
        Mono response = lines.collectList().map(line -> String.join((CharSequence)"", line)).map(this::toResponse);
        return new OpenAIHttpExecutor.ReactiveExecution((Flux<String>)lines, response);
    }

    @Override
    public boolean canStream(I input) {
        return this.streamable && input.stream();
    }

    protected void configureObjectMapper() {
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    protected String getEnv(String key) {
        return System.getenv(key);
    }

    protected String toJson(I request) {
        try {
            return this.objectMapper.writeValueAsString(request);
        }
        catch (Exception e) {
            throw new UnparseableRequestException(e);
        }
    }

    @NotNull
    protected Request prepareRequest(I request) {
        this.reinitializeExecutionIdentification();
        String json = this.toJson(request);
        this.log("Incoming request to {}{} with body: {}", this.baseUrl, this.resourceUri, json);
        return new Request.Builder().url(this.baseUrl + this.resourceUri).post(RequestBody.create((String)json, (MediaType)DEFAULT_MEDIA_TYPE)).build();
    }

    protected O toResponse(Response response) throws IOException {
        try {
            String body = response.body().string();
            this.log("Received raw response: {}", body);
            return this.toResponse(body);
        }
        catch (IOException e) {
            throw new HttpCallFailedException(this.baseUrl + this.resourceUri, e);
        }
    }

    protected O toResponse(String response) {
        try {
            this.log("Received raw response: {}", response);
            return (O)((Mergeable)this.objectMapper.readValue(response, this.responseType));
        }
        catch (Exception e) {
            throw new UnparseableResponseException(response, this.responseType, e);
        }
    }

    protected ErrorResponseHolder toError(String response) {
        try {
            this.log("Received error response: {}", response);
            return (ErrorResponseHolder)this.objectMapper.readValue(response, ErrorResponseHolder.class);
        }
        catch (Exception e) {
            throw new UnparseableResponseException(response, this.responseType, e);
        }
    }

    protected void log(String message, Object ... args) {
        String enabled = this.getEnv(AvailableEnvironmentVariables.OPENAI_LOGGING_ENABLED.name());
        if (enabled == null) {
            return;
        }
        String logMessage = "[" + this.currentExecutionIdentifier + "]: " + message;
        String level = this.getEnv(AvailableEnvironmentVariables.OPENAI_LOGGING_LEVEL.name());
        if (level == null) {
            this.log.debug(logMessage, args);
            return;
        }
        this.log.atLevel(Level.valueOf((String)level.toUpperCase())).log(logMessage, args);
    }

    protected void reinitializeExecutionIdentification() {
        this.currentExecutionIdentifier = UUID.randomUUID().toString();
    }

    protected MultipartBody toFormData(Object obj) {
        MultipartBody.Builder builder = new MultipartBody.Builder(Objects.requireNonNullElse(this.multipartBoundary, UUID.randomUUID().toString())).setType(MultipartBody.FORM);
        this.hydrateFormData(builder, obj, new HashSet<Object>());
        return builder.build();
    }

    protected void hydrateFormData(MultipartBody.Builder builder, Object obj, Set<Object> visited) {
        Arrays.stream(obj.getClass().getDeclaredFields()).filter(AccessibleObject::trySetAccessible).forEach(field -> {
            if (File.class.isAssignableFrom(field.getType())) {
                File file = DefaultOpenAIHttpExecutor.getField(field, obj, File.class);
                if (file != null) {
                    builder.addFormDataPart(this.convertFormDataFieldName(field.getName()), file.getName(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)this.getFormDataMimeType())));
                }
            } else if (Streamable.class.isAssignableFrom(field.getType())) {
                Streamable streamable = DefaultOpenAIHttpExecutor.getField(field, obj, Streamable.class);
                if (streamable != null && !visited.contains(streamable)) {
                    visited.add(streamable);
                    this.hydrateFormData(builder, streamable, visited);
                }
            } else {
                Object value = DefaultOpenAIHttpExecutor.getField(field, obj, Object.class);
                if (value != null) {
                    builder.addFormDataPart(this.convertFormDataFieldName(field.getName()), value.toString());
                }
            }
        });
    }

    protected String getFormDataMimeType() {
        return Objects.requireNonNullElse(this.formDataMimeType, "application/octet-stream");
    }

    protected void setFormDataMimeType(String mimeType) {
        this.formDataMimeType = mimeType;
    }

    protected void setMultipartBoundary(String boundary) {
        this.multipartBoundary = boundary;
    }

    protected String convertFormDataFieldName(String originalName) {
        return originalName.replaceAll(CAMEL_TO_SNAKE_CASE_PATTERN, "$1_$2").toLowerCase();
    }

    private void throwOnError(Response httpResponse) throws IOException {
        if (httpResponse.code() >= 300) {
            ErrorResponseHolder errorHolder = this.toError(httpResponse.body().string());
            throw new OpenAIRespondedNot2xxException(errorHolder, httpResponse.code());
        }
    }
}

