/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.http;

import bg.codexio.ai.openai.api.http.HttpTimeout;
import bg.codexio.ai.openai.api.http.HttpTimeouts;
import bg.codexio.ai.openai.api.payload.credentials.ApiCredentials;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class HttpExecutorContext {
    private final ApiCredentials credentials;
    private final HttpTimeouts timeouts;

    public HttpExecutorContext(ApiCredentials credentials, HttpTimeouts timeouts) {
        this.credentials = credentials;
        this.timeouts = timeouts;
    }

    public HttpExecutorContext(ApiCredentials credentials) {
        this(credentials, new HttpTimeouts(new HttpTimeout(3L, TimeUnit.MINUTES), new HttpTimeout(3L, TimeUnit.MINUTES), new HttpTimeout(3L, TimeUnit.MINUTES)));
    }

    public HttpExecutorContext withCallTimeout(long timeout, TimeUnit timeUnit) {
        return new HttpExecutorContext(this.credentials(), new HttpTimeouts(new HttpTimeout(timeout, timeUnit), this.timeouts().connect(), this.timeouts().read()));
    }

    public HttpExecutorContext withConnectTimeout(long timeout, TimeUnit timeUnit) {
        return new HttpExecutorContext(this.credentials(), new HttpTimeouts(this.timeouts().call(), new HttpTimeout(timeout, timeUnit), this.timeouts().read()));
    }

    public HttpExecutorContext withReadTimeout(long timeout, TimeUnit timeUnit) {
        return new HttpExecutorContext(this.credentials(), new HttpTimeouts(this.timeouts().call(), this.timeouts().connect(), new HttpTimeout(timeout, timeUnit)));
    }

    public ApiCredentials credentials() {
        return this.credentials;
    }

    public HttpTimeouts timeouts() {
        return this.timeouts;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HttpExecutorContext that = (HttpExecutorContext)obj;
        return Objects.equals(this.credentials, that.credentials) && Objects.equals(this.timeouts, that.timeouts);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.timeouts);
    }

    public String toString() {
        return "HttpExecutorContext[credentials=" + this.credentials + ", timeouts=" + this.timeouts + "]";
    }
}

