/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.vision.request;

import bg.codexio.ai.openai.api.payload.Streamable;
import bg.codexio.ai.openai.api.payload.vision.request.MessageContentHolder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class VisionRequest
implements Streamable {
    private final String model;
    private final List<MessageContentHolder> messages;
    private final Integer maxTokens;

    public VisionRequest() {
        this(null, null, null);
    }

    public VisionRequest(String model, List<MessageContentHolder> messages, Integer maxTokens) {
        this.model = model;
        this.messages = messages;
        this.maxTokens = maxTokens;
    }

    public static VisionRequest empty() {
        return new VisionRequest("", new ArrayList<MessageContentHolder>(), null);
    }

    @Override
    public boolean stream() {
        return false;
    }

    @JsonProperty
    public String model() {
        return this.model;
    }

    @JsonProperty
    public List<MessageContentHolder> messages() {
        return this.messages;
    }

    @JsonProperty
    public Integer maxTokens() {
        return this.maxTokens;
    }

    public VisionRequest withModel(String model) {
        return new VisionRequest(model, this.messages(), this.maxTokens());
    }

    public VisionRequest withMessages(MessageContentHolder messageHolder) {
        ArrayList<MessageContentHolder> messages = new ArrayList<MessageContentHolder>(this.messages());
        messages.add(messageHolder);
        return new VisionRequest(this.model(), messages, this.maxTokens());
    }

    public VisionRequest withMessageOn(int index, MessageContentHolder messageHolder) {
        ArrayList<MessageContentHolder> messages = new ArrayList<MessageContentHolder>(this.messages());
        messages.set(index, messageHolder);
        return new VisionRequest(this.model(), messages, this.maxTokens());
    }

    public VisionRequest withTokens(Integer maxTokens) {
        return new VisionRequest(this.model(), this.messages(), maxTokens);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VisionRequest that = (VisionRequest)obj;
        return Objects.equals(this.model, that.model) && Objects.equals(this.messages, that.messages) && Objects.equals(this.maxTokens, that.maxTokens);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.messages, this.maxTokens);
    }

    public String toString() {
        return "VisionRequest[model=" + this.model + ", messages=" + this.messages + ", maxTokens=" + this.maxTokens + "]";
    }
}

