/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.voice.request;

import bg.codexio.ai.openai.api.payload.Streamable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.Objects;

public final class TranscriptionRequest
implements Streamable {
    private final File file;
    private final String model;
    private final String language;
    private final String prompt;
    private final String responseFormat;
    private final Double temperature;
    private final Boolean stream;

    public TranscriptionRequest() {
        this(null, null, null, null, null, null, null);
    }

    public TranscriptionRequest(File file, String model, String language, String prompt, String responseFormat, Double temperature, Boolean stream) {
        this.file = file;
        this.model = model;
        this.language = language;
        this.prompt = prompt;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
        this.stream = stream;
    }

    public static Builder builder() {
        return new Builder(null, null, null, null, null, null, null);
    }

    @Override
    public boolean stream() {
        return false;
    }

    @JsonProperty
    public File file() {
        return this.file;
    }

    @JsonProperty
    public String model() {
        return this.model;
    }

    @JsonProperty
    public String language() {
        return this.language;
    }

    @JsonProperty
    public String prompt() {
        return this.prompt;
    }

    @JsonProperty
    public String responseFormat() {
        return this.responseFormat;
    }

    @JsonProperty
    public Double temperature() {
        return this.temperature;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TranscriptionRequest that = (TranscriptionRequest)obj;
        return Objects.equals(this.file, that.file) && Objects.equals(this.model, that.model) && Objects.equals(this.language, that.language) && Objects.equals(this.prompt, that.prompt) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.temperature, that.temperature);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.model, this.language, this.prompt, this.responseFormat, this.temperature);
    }

    public String toString() {
        return "TranscriptionRequest[file=" + this.file + ", model=" + this.model + ", language=" + this.language + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + "]";
    }

    public static final class Builder {
        private final File file;
        private final String model;
        private final String language;
        private final String prompt;
        private final String responseFormat;
        private final Double temperature;
        private final Boolean stream;

        public Builder(File file, String model, String language, String prompt, String responseFormat, Double temperature, Boolean stream) {
            this.file = file;
            this.model = model;
            this.language = language;
            this.prompt = prompt;
            this.responseFormat = responseFormat;
            this.temperature = temperature;
            this.stream = stream;
        }

        public Builder withFile(File file) {
            return new Builder(file, this.model, this.language, this.prompt, this.responseFormat, this.temperature, this.stream);
        }

        public Builder withModel(String model) {
            return new Builder(this.file, model, this.language, this.prompt, this.responseFormat, this.temperature, this.stream);
        }

        public Builder withLanguage(String language) {
            return new Builder(this.file, this.model, language, this.prompt, this.responseFormat, this.temperature, this.stream);
        }

        public Builder withPrompt(String prompt) {
            return new Builder(this.file, this.model, this.language, prompt, this.responseFormat, this.temperature, this.stream);
        }

        public Builder withFormat(String responseFormat) {
            return new Builder(this.file, this.model, this.language, this.prompt, responseFormat, this.temperature, this.stream);
        }

        public Builder withTemperature(Double temperature) {
            return new Builder(this.file, this.model, this.language, this.prompt, this.responseFormat, temperature, this.stream);
        }

        public TranscriptionRequest build() {
            return new TranscriptionRequest(this.file, this.model, this.language, this.prompt, this.responseFormat, this.temperature, this.stream);
        }

        public File file() {
            return this.file;
        }

        public String model() {
            return this.model;
        }

        public String language() {
            return this.language;
        }

        public String prompt() {
            return this.prompt;
        }

        public String responseFormat() {
            return this.responseFormat;
        }

        public Double temperature() {
            return this.temperature;
        }

        public Boolean stream() {
            return this.stream;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Builder that = (Builder)obj;
            return Objects.equals(this.file, that.file) && Objects.equals(this.model, that.model) && Objects.equals(this.language, that.language) && Objects.equals(this.prompt, that.prompt) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.stream, that.stream);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.model, this.language, this.prompt, this.responseFormat, this.temperature, this.stream);
        }

        public String toString() {
            return "Builder[file=" + this.file + ", model=" + this.model + ", language=" + this.language + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + "stream=" + this.stream + "]";
        }
    }
}

