/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.voice.request;

import bg.codexio.ai.openai.api.payload.Streamable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.util.Objects;

public final class TranslationRequest
implements Streamable {
    private final File file;
    private final String model;
    private final String prompt;
    private final String responseFormat;
    private final Double temperature;

    public TranslationRequest() {
        this(null, null, null, null, null);
    }

    public TranslationRequest(File file, String model, String prompt, String responseFormat, Double temperature) {
        this.file = file;
        this.model = model;
        this.prompt = prompt;
        this.responseFormat = responseFormat;
        this.temperature = temperature;
    }

    public static Builder builder() {
        return new Builder(null, null, null, null, null);
    }

    @Override
    public boolean stream() {
        return false;
    }

    @JsonProperty
    public File file() {
        return this.file;
    }

    @JsonProperty
    public String model() {
        return this.model;
    }

    @JsonProperty
    public String prompt() {
        return this.prompt;
    }

    @JsonProperty
    public String responseFormat() {
        return this.responseFormat;
    }

    @JsonProperty
    public Double temperature() {
        return this.temperature;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TranslationRequest that = (TranslationRequest)obj;
        return Objects.equals(this.file, that.file) && Objects.equals(this.model, that.model) && Objects.equals(this.prompt, that.prompt) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.temperature, that.temperature);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.model, this.prompt, this.responseFormat, this.temperature);
    }

    public String toString() {
        return "TranslationRequest[file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + "]";
    }

    public static final class Builder {
        private final File file;
        private final String model;
        private final String prompt;
        private final String responseFormat;
        private final Double temperature;

        public Builder(File file, String model, String prompt, String responseFormat, Double temperature) {
            this.file = file;
            this.model = model;
            this.prompt = prompt;
            this.responseFormat = responseFormat;
            this.temperature = temperature;
        }

        public Builder withFile(File file) {
            return new Builder(file, this.model, this.prompt, this.responseFormat, this.temperature);
        }

        public Builder withModel(String model) {
            return new Builder(this.file, model, this.prompt, this.responseFormat, this.temperature);
        }

        public Builder withPrompt(String prompt) {
            return new Builder(this.file, this.model, prompt, this.responseFormat, this.temperature);
        }

        public Builder withFormat(String responseFormat) {
            return new Builder(this.file, this.model, this.prompt, responseFormat, this.temperature);
        }

        public Builder withTemperature(Double temperature) {
            return new Builder(this.file, this.model, this.prompt, this.responseFormat, temperature);
        }

        public TranslationRequest build() {
            return new TranslationRequest(this.file, this.model, this.prompt, this.responseFormat, this.temperature);
        }

        public File file() {
            return this.file;
        }

        public String model() {
            return this.model;
        }

        public String prompt() {
            return this.prompt;
        }

        public String responseFormat() {
            return this.responseFormat;
        }

        public Double temperature() {
            return this.temperature;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Builder that = (Builder)obj;
            return Objects.equals(this.file, that.file) && Objects.equals(this.model, that.model) && Objects.equals(this.prompt, that.prompt) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.temperature, that.temperature);
        }

        public int hashCode() {
            return Objects.hash(this.file, this.model, this.prompt, this.responseFormat, this.temperature);
        }

        public String toString() {
            return "Builder[file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", responseFormat=" + this.responseFormat + ", temperature=" + this.temperature + "]";
        }
    }
}

