/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.chat.request;

import bg.codexio.ai.openai.api.payload.Streamable;
import bg.codexio.ai.openai.api.payload.chat.ChatMessage;
import bg.codexio.ai.openai.api.payload.chat.request.ChatTool;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ChatMessageRequest
implements Streamable {
    private final String model;
    private final List<ChatMessage> messages;
    private final Double frequencyPenalty;
    private final Map<String, Integer> logitBias;
    private final Integer maxTokens;
    private final Integer n;
    private final Double presencePenalty;
    private final Integer seed;
    private final String[] stop;
    private final boolean stream;
    private final Double temperature;
    private final Double topP;
    private final List<ChatTool> tools;
    private final ChatTool.ChatToolChoice toolChoice;
    private final String user;

    public ChatMessageRequest() {
        this(null, new ArrayList<ChatMessage>(), 0.0, null, 150, 1, 0.0, null, null, false, 1.0, 1.0, new ArrayList<ChatTool>(), null, null);
    }

    public ChatMessageRequest(String model, List<ChatMessage> messages, Double frequencyPenalty, Map<String, Integer> logitBias, Integer maxTokens, Integer n, Double presencePenalty, Integer seed, String[] stop, boolean stream, Double temperature, Double topP, List<ChatTool> tools, ChatTool.ChatToolChoice toolChoice, String user) {
        this.model = model;
        this.messages = messages;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.maxTokens = maxTokens;
        this.n = n;
        this.presencePenalty = presencePenalty;
        this.seed = seed;
        this.stop = stop;
        this.stream = stream;
        this.temperature = temperature;
        this.topP = topP;
        this.tools = tools;
        this.toolChoice = toolChoice;
        this.user = user;
    }

    public static Builder builder() {
        return new Builder("", new ArrayList<ChatMessage>(), null, null, null, null, null, null, null, false, null, null, null, null, null);
    }

    @JsonProperty
    public String model() {
        return this.model;
    }

    @JsonProperty
    public List<ChatMessage> messages() {
        return this.messages;
    }

    @JsonProperty
    public Double frequencyPenalty() {
        return this.frequencyPenalty;
    }

    @JsonProperty
    public Map<String, Integer> logitBias() {
        return this.logitBias;
    }

    @JsonProperty
    public Integer maxTokens() {
        return this.maxTokens;
    }

    @JsonProperty
    public Integer n() {
        return this.n;
    }

    @JsonProperty
    public Double presencePenalty() {
        return this.presencePenalty;
    }

    @JsonProperty
    public Integer seed() {
        return this.seed;
    }

    @JsonProperty
    public String[] stop() {
        return this.stop;
    }

    @JsonProperty
    public Double temperature() {
        return this.temperature;
    }

    @JsonProperty
    public Double topP() {
        return this.topP;
    }

    @JsonProperty
    public List<ChatTool> tools() {
        return this.tools;
    }

    @JsonProperty
    public ChatTool.ChatToolChoice toolChoice() {
        return this.toolChoice;
    }

    @JsonProperty
    public String user() {
        return this.user;
    }

    @Override
    @JsonProperty
    public boolean stream() {
        return this.stream;
    }

    public static final class Builder {
        private final String model;
        private final List<ChatMessage> messages;
        private final Double frequencyPenalty;
        private final Map<String, Integer> logitBias;
        private final Integer maxTokens;
        private final Integer n;
        private final Double presencePenalty;
        private final Integer seed;
        private final String[] stop;
        private final boolean stream;
        private final Double temperature;
        private final Double topP;
        private final List<ChatTool> tools;
        private final ChatTool.ChatToolChoice toolChoice;
        private final String user;

        public Builder(String model, List<ChatMessage> messages, Double frequencyPenalty, Map<String, Integer> logitBias, Integer maxTokens, Integer n, Double presencePenalty, Integer seed, String[] stop, boolean stream, Double temperature, Double topP, List<ChatTool> tools, ChatTool.ChatToolChoice toolChoice, String user) {
            this.model = model;
            this.messages = messages;
            this.frequencyPenalty = frequencyPenalty;
            this.logitBias = logitBias;
            this.maxTokens = maxTokens;
            this.n = n;
            this.presencePenalty = presencePenalty;
            this.seed = seed;
            this.stop = stop;
            this.stream = stream;
            this.temperature = temperature;
            this.topP = topP;
            this.tools = tools;
            this.toolChoice = toolChoice;
            this.user = user;
        }

        public Builder withModel(String model) {
            return new Builder(model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withMessages(List<ChatMessage> messages) {
            return new Builder(this.model, messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder addMessage(ChatMessage message) {
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(Objects.requireNonNullElse(this.messages, new ArrayList()));
            messages.add(message);
            return this.withMessages(messages);
        }

        public Builder withFrequencyPenalty(Double frequencyPenalty) {
            return new Builder(this.model, this.messages, frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withLogitBias(Map<String, Integer> logitBias) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withMaxTokens(Integer maxTokens) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withN(Integer n) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withPresencePenalty(Double presencePenalty) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withSeed(Integer seed) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withStop(String[] stop) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder shouldStream(boolean stream) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withTemperature(Double temperature) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withTopP(Double topP) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withTools(List<ChatTool> tools) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, tools, this.toolChoice, this.user);
        }

        public Builder addTool(ChatTool chatTool) {
            ArrayList<ChatTool> tools = new ArrayList<ChatTool>(Objects.requireNonNullElse(this.tools, new ArrayList()));
            tools.add(chatTool);
            return this.withTools(tools);
        }

        public Builder withToolChoice(ChatTool.ChatToolChoice toolChoice) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, toolChoice, this.user);
        }

        public Builder withUser(String user) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, user);
        }

        public ChatMessageRequest build() {
            return new ChatMessageRequest(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public String model() {
            return this.model;
        }

        public List<ChatMessage> messages() {
            return this.messages;
        }

        public Double frequencyPenalty() {
            return this.frequencyPenalty;
        }

        public Map<String, Integer> logitBias() {
            return this.logitBias;
        }

        public Integer maxTokens() {
            return this.maxTokens;
        }

        public Integer n() {
            return this.n;
        }

        public Double presencePenalty() {
            return this.presencePenalty;
        }

        public Integer seed() {
            return this.seed;
        }

        public String[] stop() {
            return this.stop;
        }

        public boolean stream() {
            return this.stream;
        }

        public Double temperature() {
            return this.temperature;
        }

        public Double topP() {
            return this.topP;
        }

        public List<ChatTool> tools() {
            return this.tools;
        }

        public ChatTool.ChatToolChoice toolChoice() {
            return this.toolChoice;
        }

        public String user() {
            return this.user;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Builder that = (Builder)obj;
            return Objects.equals(this.model, that.model) && Objects.equals(this.messages, that.messages) && Objects.equals(this.frequencyPenalty, that.frequencyPenalty) && Objects.equals(this.logitBias, that.logitBias) && Objects.equals(this.maxTokens, that.maxTokens) && Objects.equals(this.n, that.n) && Objects.equals(this.presencePenalty, that.presencePenalty) && Objects.equals(this.seed, that.seed) && Objects.equals(this.stop, that.stop) && this.stream == that.stream && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.topP, that.topP) && Objects.equals(this.tools, that.tools) && Objects.equals(this.toolChoice, that.toolChoice) && Objects.equals(this.user, that.user);
        }

        public int hashCode() {
            return Objects.hash(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public String toString() {
            return "Builder[model=" + this.model + ", messages=" + this.messages + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", maxTokens=" + this.maxTokens + ", n=" + this.n + ", presencePenalty=" + this.presencePenalty + ", seed=" + this.seed + ", stop=" + this.stop + ", stream=" + this.stream + ", temperature=" + this.temperature + ", topP=" + this.topP + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ", user=" + this.user + "]";
        }
    }
}

