/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.chat.response;

import bg.codexio.ai.openai.api.payload.Mergeable;
import bg.codexio.ai.openai.api.payload.chat.response.ChatChoiceResponse;
import bg.codexio.ai.openai.api.payload.chat.response.ChatUsageResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public final class ChatMessageResponse
implements Mergeable<ChatMessageResponse> {
    private final String id;
    private final String object;
    private final long created;
    private final String model;
    private final ChatUsageResponse usage;
    private final List<ChatChoiceResponse> choices;

    public ChatMessageResponse() {
        this(null, null, 1L, null, null, null);
    }

    public ChatMessageResponse(String id, String object, long created, String model, ChatUsageResponse usage, List<ChatChoiceResponse> choices) {
        this.id = id;
        this.object = object;
        this.created = created;
        this.model = model;
        this.usage = usage;
        this.choices = choices;
    }

    @Override
    public ChatMessageResponse merge(ChatMessageResponse other) {
        if (other == null) {
            return this;
        }
        ChatUsageResponse thisUsage = Objects.requireNonNullElse(this.usage(), ChatUsageResponse.empty());
        ChatUsageResponse otherUsage = Objects.requireNonNullElse(other.usage(), ChatUsageResponse.empty());
        return new ChatMessageResponse(this.id(), this.object(), Math.max(this.created(), other.created()), this.model(), thisUsage.merge(otherUsage), Mergeable.join(this.choices(), other.choices(), c -> c.delta() != null || c.message() != null, c -> c.delta() != null ? c.delta().role() : c.message().role(), ChatChoiceResponse::empty, ChatChoiceResponse::merge, x -> true));
    }

    @JsonProperty
    public String id() {
        return this.id;
    }

    @JsonProperty
    public String object() {
        return this.object;
    }

    @JsonProperty
    public long created() {
        return this.created;
    }

    @JsonProperty
    public String model() {
        return this.model;
    }

    @JsonProperty
    public ChatUsageResponse usage() {
        return this.usage;
    }

    @JsonProperty
    public List<ChatChoiceResponse> choices() {
        return this.choices;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ChatMessageResponse that = (ChatMessageResponse)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.object, that.object) && this.created == that.created && Objects.equals(this.model, that.model) && Objects.equals(this.usage, that.usage) && Objects.equals(this.choices, that.choices);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.object, this.created, this.model, this.usage, this.choices);
    }

    public String toString() {
        return "ChatMessageResponse[id=" + this.id + ", object=" + this.object + ", created=" + this.created + ", model=" + this.model + ", usage=" + this.usage + ", choices=" + this.choices + "]";
    }
}

