/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.credentials;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public final class ApiCredentials {
    public static final String BASE_URL = "https://api.openai.com/v1";
    private final String apiKey;
    private final String organization;
    private final String baseUrl;

    public ApiCredentials(String apiKey, String organization, String baseUrl) {
        this.apiKey = apiKey;
        this.organization = organization;
        this.baseUrl = baseUrl;
    }

    public ApiCredentials(String apiKey) {
        this(apiKey, "", BASE_URL);
    }

    public String baseUrl() {
        return Optional.ofNullable(this.baseUrl).map(String::trim).filter(Predicate.not(String::isBlank)).orElse(BASE_URL);
    }

    public String apiKey() {
        return this.apiKey;
    }

    public String organization() {
        return this.organization;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ApiCredentials that = (ApiCredentials)obj;
        return Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.organization, that.organization) && Objects.equals(this.baseUrl, that.baseUrl);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.organization, this.baseUrl);
    }

    public String toString() {
        return "ApiCredentials[apiKey=" + this.apiKey + ", organization=" + this.organization + ", baseUrl=" + this.baseUrl + "]";
    }
}

