/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.images.request;

import bg.codexio.ai.openai.api.payload.images.request.ImageRequest;
import java.io.File;
import java.util.Objects;
import java.util.function.Function;

public final class ImageRequestBuilder<R extends ImageRequest> {
    private final Function<ImageRequestBuilder<R>, R> specificRequestCreator;
    private final String prompt;
    private final String model;
    private final Integer n;
    private final String quality;
    private final String responseFormat;
    private final String size;
    private final String style;
    private final String user;
    private final File image;
    private final File mask;

    public ImageRequestBuilder(Function<ImageRequestBuilder<R>, R> specificRequestCreator, String prompt, String model, Integer n, String quality, String responseFormat, String size, String style, String user, File image, File mask) {
        this.specificRequestCreator = specificRequestCreator;
        this.prompt = prompt;
        this.model = model;
        this.n = n;
        this.quality = quality;
        this.responseFormat = responseFormat;
        this.size = size;
        this.style = style;
        this.user = user;
        this.image = image;
        this.mask = mask;
    }

    public static <R extends ImageRequest> ImageRequestBuilder<R> builder() {
        return new ImageRequestBuilder<R>(null, null, null, null, null, null, null, null, null, null, null);
    }

    public ImageRequestBuilder<R> withSpecificRequestCreator(Function<ImageRequestBuilder<R>, R> specificRequestCreator) {
        return new ImageRequestBuilder<R>(specificRequestCreator, this.prompt, this.model, this.n, this.quality, this.responseFormat, this.size, this.style, this.user, this.image, this.mask);
    }

    public ImageRequestBuilder<R> withPrompt(String prompt) {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, prompt, this.model, this.n, this.quality, this.responseFormat, this.size, this.style, this.user, this.image, this.mask);
    }

    public ImageRequestBuilder<R> withModel(String model) {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, this.prompt, model, this.n, this.quality, this.responseFormat, this.size, this.style, this.user, this.image, this.mask);
    }

    public ImageRequestBuilder<R> withN(Integer n) {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, this.prompt, this.model, n, this.quality, this.responseFormat, this.size, this.style, this.user, this.image, this.mask);
    }

    public ImageRequestBuilder<R> withQuality(String quality) {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, this.prompt, this.model, this.n, quality, this.responseFormat, this.size, this.style, this.user, this.image, this.mask);
    }

    public ImageRequestBuilder<R> withResponseFormat(String responseFormat) {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, this.prompt, this.model, this.n, this.quality, responseFormat, this.size, this.style, this.user, this.image, this.mask);
    }

    public ImageRequestBuilder<R> withSize(String size) {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, this.prompt, this.model, this.n, this.quality, this.responseFormat, size, this.style, this.user, this.image, this.mask);
    }

    public ImageRequestBuilder<R> withStyle(String style) {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, this.prompt, this.model, this.n, this.quality, this.responseFormat, this.size, style, this.user, this.image, this.mask);
    }

    public ImageRequestBuilder<R> withUser(String user) {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, this.prompt, this.model, this.n, this.quality, this.responseFormat, this.size, this.style, user, this.image, this.mask);
    }

    public ImageRequestBuilder<R> withImage(File image) {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, this.prompt, this.model, this.n, this.quality, this.responseFormat, this.size, this.style, this.user, image, this.mask);
    }

    public ImageRequestBuilder<R> withMask(File mask) {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, this.prompt, this.model, this.n, this.quality, this.responseFormat, this.size, this.style, this.user, this.image, mask);
    }

    public ImageRequestBuilder<R> build() {
        return new ImageRequestBuilder<R>(this.specificRequestCreator, this.prompt, this.model, this.n, this.quality, this.responseFormat, this.size, this.style, this.user, this.image, this.mask);
    }

    public Function<ImageRequestBuilder<R>, R> specificRequestCreator() {
        return this.specificRequestCreator;
    }

    public String prompt() {
        return this.prompt;
    }

    public String model() {
        return this.model;
    }

    public Integer n() {
        return this.n;
    }

    public String quality() {
        return this.quality;
    }

    public String responseFormat() {
        return this.responseFormat;
    }

    public String size() {
        return this.size;
    }

    public String style() {
        return this.style;
    }

    public String user() {
        return this.user;
    }

    public File image() {
        return this.image;
    }

    public File mask() {
        return this.mask;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ImageRequestBuilder that = (ImageRequestBuilder)obj;
        return Objects.equals(this.specificRequestCreator, that.specificRequestCreator) && Objects.equals(this.prompt, that.prompt) && Objects.equals(this.model, that.model) && Objects.equals(this.n, that.n) && Objects.equals(this.quality, that.quality) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.size, that.size) && Objects.equals(this.style, that.style) && Objects.equals(this.user, that.user) && Objects.equals(this.image, that.image) && Objects.equals(this.mask, that.mask);
    }

    public int hashCode() {
        return Objects.hash(this.specificRequestCreator, this.prompt, this.model, this.n, this.quality, this.responseFormat, this.size, this.style, this.user, this.image, this.mask);
    }

    public String toString() {
        return "ImageRequestBuilder[specificRequestCreator=" + this.specificRequestCreator + ", prompt=" + this.prompt + ", model=" + this.model + ", n=" + this.n + ", quality=" + this.quality + ", responseFormat=" + this.responseFormat + ", size=" + this.size + ", style=" + this.style + ", user=" + this.user + ", image=" + this.image + ", mask=" + this.mask + "]";
    }
}

