/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.vision.request;

import bg.codexio.ai.openai.api.payload.vision.request.VisionMessage;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class MessageContentHolder {
    private final List<VisionMessage> content;

    public MessageContentHolder() {
        this(null);
    }

    public MessageContentHolder(List<VisionMessage> content) {
        this.content = content;
    }

    @JsonProperty
    public List<VisionMessage> content() {
        return this.content;
    }

    public String getRole() {
        return "user";
    }

    public MessageContentHolder withContent(VisionMessage message) {
        ArrayList<VisionMessage> content = new ArrayList<VisionMessage>(this.content());
        content.add(message);
        return new MessageContentHolder(content);
    }

    public MessageContentHolder withContentOn(int index, VisionMessage message) {
        ArrayList<VisionMessage> content = new ArrayList<VisionMessage>(this.content());
        content.set(index, message);
        return new MessageContentHolder(content);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MessageContentHolder that = (MessageContentHolder)obj;
        return Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hash(this.content);
    }

    public String toString() {
        return "MessageContentHolder[content=" + this.content + "]";
    }
}

