/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.voice.request;

import bg.codexio.ai.openai.api.payload.Streamable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public final class SpeechRequest
implements Streamable {
    private final String model;
    private final String input;
    private final String voice;
    private final String responseFormat;
    private final Double speed;

    public SpeechRequest() {
        this(null, null, null, null, null);
    }

    public SpeechRequest(String model, String input, String voice, String responseFormat, Double speed) {
        this.model = model;
        this.input = input;
        this.voice = voice;
        this.responseFormat = responseFormat;
        this.speed = speed;
    }

    public static Builder builder() {
        return new Builder(null, null, null, null, null);
    }

    @Override
    public boolean stream() {
        return false;
    }

    @JsonProperty
    public String model() {
        return this.model;
    }

    @JsonProperty
    public String input() {
        return this.input;
    }

    @JsonProperty
    public String voice() {
        return this.voice;
    }

    @JsonProperty
    public String responseFormat() {
        return this.responseFormat;
    }

    @JsonProperty
    public Double speed() {
        return this.speed;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SpeechRequest that = (SpeechRequest)obj;
        return Objects.equals(this.model, that.model) && Objects.equals(this.input, that.input) && Objects.equals(this.voice, that.voice) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.speed, that.speed);
    }

    public int hashCode() {
        return Objects.hash(this.model, this.input, this.voice, this.responseFormat, this.speed);
    }

    public String toString() {
        return "SpeechRequest[model=" + this.model + ", input=" + this.input + ", voice=" + this.voice + ", responseFormat=" + this.responseFormat + ", speed=" + this.speed + "]";
    }

    public static final class Builder {
        private final String model;
        private final String input;
        private final String voice;
        private final String responseFormat;
        private final Double speed;

        public Builder(String model, String input, String voice, String responseFormat, Double speed) {
            this.model = model;
            this.input = input;
            this.voice = voice;
            this.responseFormat = responseFormat;
            this.speed = speed;
        }

        public Builder withModel(String model) {
            return new Builder(model, this.input, this.voice, this.responseFormat, this.speed);
        }

        public Builder withInput(String input) {
            return new Builder(this.model, input, this.voice, this.responseFormat, this.speed);
        }

        public Builder withVoice(String voice) {
            return new Builder(this.model, this.input, voice, this.responseFormat, this.speed);
        }

        public Builder withFormat(String responseFormat) {
            return new Builder(this.model, this.input, this.voice, responseFormat, this.speed);
        }

        public Builder withSpeed(Double speed) {
            return new Builder(this.model, this.input, this.voice, this.responseFormat, speed);
        }

        public SpeechRequest build() {
            return new SpeechRequest(this.model, this.input, this.voice, this.responseFormat, this.speed);
        }

        public String model() {
            return this.model;
        }

        public String input() {
            return this.input;
        }

        public String voice() {
            return this.voice;
        }

        public String responseFormat() {
            return this.responseFormat;
        }

        public Double speed() {
            return this.speed;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Builder that = (Builder)obj;
            return Objects.equals(this.model, that.model) && Objects.equals(this.input, that.input) && Objects.equals(this.voice, that.voice) && Objects.equals(this.responseFormat, that.responseFormat) && Objects.equals(this.speed, that.speed);
        }

        public int hashCode() {
            return Objects.hash(this.model, this.input, this.voice, this.responseFormat, this.speed);
        }

        public String toString() {
            return "Builder[model=" + this.model + ", input=" + this.input + ", voice=" + this.voice + ", responseFormat=" + this.responseFormat + ", speed=" + this.speed + "]";
        }
    }
}

