/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface Mergeable<T extends Mergeable<?>> {
    public static <U extends Mergeable<U>> U doMerge(U source, U target) {
        return target == null ? source : source.merge(target);
    }

    public static <T, U> List<T> join(Collection<T> source, Collection<T> target, Predicate<T> filter, Function<? super T, U> grouping, Supplier<T> emptySupplier, BinaryOperator<T> merger, Predicate<T> shallPersist) {
        Map sourceMap = ((Collection)Objects.requireNonNullElse(source, new ArrayList())).stream().filter(filter).collect(Collectors.groupingBy(grouping));
        Map targetMap = ((Collection)Objects.requireNonNullElse(target, new ArrayList())).stream().filter(filter).collect(Collectors.groupingBy(grouping));
        HashSet<U> keys = new HashSet<U>(sourceMap.keySet());
        keys.addAll(targetMap.keySet());
        ArrayList resultList = new ArrayList();
        keys.forEach(role -> {
            List sourceList = Objects.requireNonNullElse((List)sourceMap.get(role), new ArrayList());
            List targetList = Objects.requireNonNullElse((List)targetMap.get(role), new ArrayList());
            Object initial = sourceList.stream().reduce(emptySupplier.get(), merger);
            Object result = targetList.stream().reduce(initial, merger);
            if (shallPersist.test(result)) {
                resultList.add(result);
            }
        });
        return resultList;
    }

    public T merge(T var1);
}

