/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.assistant.request;

import bg.codexio.ai.openai.api.payload.MetadataUtils;
import bg.codexio.ai.openai.api.payload.Streamable;
import bg.codexio.ai.openai.api.payload.assistant.tool.AssistantTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public record AssistantRequest(String model, String name, String description, String instructions, List<AssistantTool> tools, List<String> fileIds, Map<String, String> metadata) implements Streamable
{
    public static Builder builder() {
        return new Builder("", null, null, null, null, null, null);
    }

    @Override
    public boolean stream() {
        return false;
    }

    public record Builder(String model, String name, String description, String instructions, List<AssistantTool> tools, List<String> fileIds, Map<String, String> metadata) {
        public Builder withModel(String model) {
            return new Builder(model, this.name, this.description, this.instructions, this.tools, this.fileIds, this.metadata);
        }

        public Builder withName(String name) {
            return new Builder(this.model, name, this.description, this.instructions, this.tools, this.fileIds, this.metadata);
        }

        public Builder withDescription(String description) {
            return new Builder(this.model, this.name, description, this.instructions, this.tools, this.fileIds, this.metadata);
        }

        public Builder withInstructions(String instructions) {
            return new Builder(this.model, this.name, this.description, instructions, this.tools, this.fileIds, this.metadata);
        }

        public Builder withTools(List<AssistantTool> tools) {
            return new Builder(this.model, this.name, this.description, this.instructions, tools, this.fileIds, this.metadata);
        }

        public Builder addTools(AssistantTool assistantTool) {
            ArrayList<AssistantTool> assistantTools = new ArrayList<AssistantTool>(Objects.requireNonNullElse(this.tools, new ArrayList()));
            assistantTools.add(assistantTool);
            return this.withTools(assistantTools);
        }

        public Builder withFileIds(List<String> fileIds) {
            return new Builder(this.model, this.name, this.description, this.instructions, this.tools, fileIds, this.metadata);
        }

        public Builder addFileId(String fileId) {
            ArrayList<String> fileIds = new ArrayList<String>(Objects.requireNonNullElse(this.fileIds, new ArrayList()));
            fileIds.add(fileId);
            return this.withFileIds(fileIds);
        }

        public Builder withMetadata(Map<String, String> metadata) {
            return new Builder(this.model, this.name, this.description, this.instructions, this.tools, this.fileIds, metadata);
        }

        public Builder addMetadata(String ... metadata) {
            Map<String, String> assistantMetadata = MetadataUtils.addMetadata(this.metadata, metadata);
            return this.withMetadata(assistantMetadata);
        }

        public AssistantRequest build() {
            return new AssistantRequest(this.model, this.name, this.description, this.instructions, this.tools, this.fileIds, this.metadata);
        }
    }
}

