/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.chat.request;

import bg.codexio.ai.openai.api.payload.Streamable;
import bg.codexio.ai.openai.api.payload.chat.ChatMessage;
import bg.codexio.ai.openai.api.payload.chat.request.ChatTool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public record ChatMessageRequest(String model, List<ChatMessage> messages, Double frequencyPenalty, Map<String, Integer> logitBias, Integer maxTokens, Integer n, Double presencePenalty, Integer seed, String[] stop, boolean stream, Double temperature, Double topP, List<ChatTool> tools, ChatTool.ChatToolChoice toolChoice, String user) implements Streamable
{
    public static Builder builder() {
        return new Builder("", new ArrayList<ChatMessage>(), null, null, null, null, null, null, null, false, null, null, null, null, null);
    }

    public record Builder(String model, List<ChatMessage> messages, Double frequencyPenalty, Map<String, Integer> logitBias, Integer maxTokens, Integer n, Double presencePenalty, Integer seed, String[] stop, boolean stream, Double temperature, Double topP, List<ChatTool> tools, ChatTool.ChatToolChoice toolChoice, String user) {
        public Builder withModel(String model) {
            return new Builder(model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withMessages(List<ChatMessage> messages) {
            return new Builder(this.model, messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder addMessage(ChatMessage message) {
            ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(Objects.requireNonNullElse(this.messages, new ArrayList()));
            messages.add(message);
            return this.withMessages(messages);
        }

        public Builder withFrequencyPenalty(Double frequencyPenalty) {
            return new Builder(this.model, this.messages, frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withLogitBias(Map<String, Integer> logitBias) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withMaxTokens(Integer maxTokens) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withN(Integer n) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withPresencePenalty(Double presencePenalty) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withSeed(Integer seed) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withStop(String[] stop) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder shouldStream(boolean stream) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withTermperature(Double temperature) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, temperature, this.topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withTopP(Double topP) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, topP, this.tools, this.toolChoice, this.user);
        }

        public Builder withTools(List<ChatTool> tools) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, tools, this.toolChoice, this.user);
        }

        public Builder addTool(ChatTool chatTool) {
            ArrayList<ChatTool> tools = new ArrayList<ChatTool>(Objects.requireNonNullElse(this.tools, new ArrayList()));
            tools.add(chatTool);
            return this.withTools(tools);
        }

        public Builder withToolChoice(ChatTool.ChatToolChoice toolChoice) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, toolChoice, this.user);
        }

        public Builder withUser(String user) {
            return new Builder(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, user);
        }

        public ChatMessageRequest build() {
            return new ChatMessageRequest(this.model, this.messages, this.frequencyPenalty, this.logitBias, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.temperature, this.topP, this.tools, this.toolChoice, this.user);
        }
    }
}

