/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.payload.message.request;

import bg.codexio.ai.openai.api.payload.MetadataUtils;
import bg.codexio.ai.openai.api.payload.Streamable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public record MessageRequest(String role, String content, List<String> fileIds, Map<String, String> metadata) implements Streamable
{
    public static Builder builder() {
        return new Builder("user", "", null, null);
    }

    @Override
    public boolean stream() {
        return false;
    }

    public record Builder(String role, String content, List<String> fileIds, Map<String, String> metadata) {
        public Builder withRole(String role) {
            return new Builder(role, this.content, this.fileIds, this.metadata);
        }

        public Builder withContent(String content) {
            return new Builder(this.role, content, this.fileIds, this.metadata);
        }

        public Builder withFileIds(List<String> fileIds) {
            return new Builder(this.role, this.content, fileIds, this.metadata);
        }

        public Builder addFileIDs(String fileId) {
            ArrayList<String> fileIds = new ArrayList<String>(Objects.requireNonNullElse(this.fileIds, new ArrayList()));
            fileIds.add(fileId);
            return this.withFileIds(fileIds);
        }

        public Builder withMetadata(Map<String, String> metadata) {
            return new Builder(this.role, this.content, this.fileIds, metadata);
        }

        public Builder addMetadata(String ... metadata) {
            Map<String, String> messageMetadata = MetadataUtils.addMetadata(this.metadata, metadata);
            return this.withMetadata(messageMetadata);
        }

        public MessageRequest build() {
            return new MessageRequest(this.role, this.content, this.fileIds, this.metadata);
        }
    }
}

