/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk;

import bg.codexio.ai.openai.api.http.HttpExecutorContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;

public class HttpBuilder<T> {
    private final HttpExecutorContext context;
    private final BiFunction<HttpExecutorContext, ObjectMapper, T> nextStepDelegate;

    public HttpBuilder(HttpExecutorContext context, BiFunction<HttpExecutorContext, ObjectMapper, T> nextStepDelegate) {
        this.context = context;
        this.nextStepDelegate = nextStepDelegate;
    }

    public T understanding(ObjectMapper mapper) {
        return this.nextStepDelegate.apply(this.context, mapper);
    }

    public HttpBuilder<T> withReadTimeout(long timeout, TimeUnit timeUnit) {
        return new HttpBuilder<T>(this.context.withReadTimeout(timeout, timeUnit), this.nextStepDelegate);
    }

    public HttpBuilder<T> withConnectTimeout(long timeout, TimeUnit timeUnit) {
        return new HttpBuilder<T>(this.context.withConnectTimeout(timeout, timeUnit), this.nextStepDelegate);
    }

    public HttpBuilder<T> withCallTimeout(long timeout, TimeUnit timeUnit) {
        return new HttpBuilder<T>(this.context.withCallTimeout(timeout, timeUnit), this.nextStepDelegate);
    }

    public T and() {
        return this.understanding(new ObjectMapper());
    }
}

