/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.images;

import bg.codexio.ai.openai.api.payload.images.Format;
import bg.codexio.ai.openai.api.payload.images.response.ImageDataResponse;
import bg.codexio.ai.openai.api.payload.images.response.ImageResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Base64;
import java.util.UUID;

public final class DownloadExecutor {
    private DownloadExecutor() {
    }

    protected static final class Streams {
        private Streams() {
        }

        static FileOutputStream outputStream(String fileName) throws FileNotFoundException {
            return new FileOutputStream(fileName);
        }
    }

    static final class FromFile {
        private FromFile() {
        }

        static File downloadFile(File targetFolder, Format format, ImageResponse image) throws IOException {
            String fileName = targetFolder.getAbsoluteFile() + "/" + UUID.randomUUID() + ".png";
            try (FileOutputStream fos = Streams.outputStream(fileName);){
                if (format == Format.URL) {
                    ReadableByteChannel channel = Channels.newChannel(URI.create(image.url()).toURL().openStream());
                    fos.getChannel().transferFrom(channel, 0L, Long.MAX_VALUE);
                } else {
                    fos.write(Base64.getDecoder().decode(image.b64Json()));
                }
                File file = new File(fileName);
                return file;
            }
        }
    }

    static final class FromResponse {
        private FromResponse() {
        }

        static File[] downloadTo(File targetFolder, ImageDataResponse response, Format format) throws IOException {
            if (!targetFolder.exists()) {
                targetFolder.mkdirs();
            }
            for (ImageResponse image : response.data()) {
                FromFile.downloadFile(targetFolder, format, image);
            }
            return targetFolder.listFiles();
        }
    }
}

