/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.auth;

import bg.codexio.ai.openai.api.payload.credentials.ApiCredentials;
import bg.codexio.ai.openai.api.payload.environment.AvailableEnvironmentVariables;
import bg.codexio.ai.openai.api.sdk.auth.SdkAuth;
import bg.codexio.ai.openai.api.sdk.auth.exception.NotValidAuthenticationMethod;

public class FromEnvironment
implements SdkAuth {
    public static final FromEnvironment AUTH = new FromEnvironment();

    FromEnvironment() {
    }

    @Override
    public ApiCredentials credentials() {
        String apiKey = this.getEnv(AvailableEnvironmentVariables.OPENAI_API_KEY.name());
        if (apiKey == null) {
            throw new NotValidAuthenticationMethod("Environment variable OPENAI_API_KEY not present.");
        }
        String organizationId = this.getEnv(AvailableEnvironmentVariables.OPENAI_ORG_ID.name());
        if (organizationId == null) {
            organizationId = "";
        }
        return new ApiCredentials(apiKey, organizationId, this.getEnv(AvailableEnvironmentVariables.OPENAI_API_BASE_URL.name()));
    }

    protected String getEnv(String key) {
        return System.getenv(key);
    }
}

