/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.vision;

import bg.codexio.ai.openai.api.http.vision.VisionHttpExecutor;
import bg.codexio.ai.openai.api.payload.vision.request.ImageUrlMessageRequest;
import bg.codexio.ai.openai.api.payload.vision.request.ImageUrlRequest;
import bg.codexio.ai.openai.api.payload.vision.request.MessageContentHolder;
import bg.codexio.ai.openai.api.payload.vision.request.VisionMessage;
import bg.codexio.ai.openai.api.payload.vision.request.VisionRequest;
import bg.codexio.ai.openai.api.sdk.vision.ImageDetailStage;
import bg.codexio.ai.openai.api.sdk.vision.VisionConfigurationStage;
import bg.codexio.ai.openai.api.sdk.vision.VisionRuntimeSelectionStage;
import java.io.File;

public class ImageChooserOrSkipStage
extends VisionConfigurationStage {
    private final int messageIndex;

    ImageChooserOrSkipStage(VisionHttpExecutor executor, VisionRequest requestContext, int messageIndex) {
        super(executor, requestContext);
        this.messageIndex = messageIndex;
    }

    public ImageDetailStage explainAnother(String urlOrBase64) {
        return this.explain(new ImageUrlRequest(urlOrBase64, null));
    }

    public ImageDetailStage explainAnother(File image) {
        return this.explain(ImageUrlRequest.fromLocalFile((File)image));
    }

    public VisionRuntimeSelectionStage andRespond() {
        return new VisionRuntimeSelectionStage(this.executor, this.requestContext);
    }

    private ImageDetailStage explain(ImageUrlRequest imageRequest) {
        return new ImageDetailStage(this.executor, this.requestContext.withMessageOn(0, ((MessageContentHolder)this.requestContext.messages().get(0)).withContent((VisionMessage)new ImageUrlMessageRequest(imageRequest))), this.messageIndex);
    }
}

