/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.vision;

import bg.codexio.ai.openai.api.http.HttpExecutorContext;
import bg.codexio.ai.openai.api.payload.credentials.ApiCredentials;
import bg.codexio.ai.openai.api.payload.vision.DetailedAnalyze;
import bg.codexio.ai.openai.api.sdk.auth.SdkAuth;
import bg.codexio.ai.openai.api.sdk.vision.ImageChooserStage;
import bg.codexio.ai.openai.api.sdk.vision.SynchronousPromptStage;
import bg.codexio.ai.openai.api.sdk.vision.Vision;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;

public class SimplifiedStage {
    private final ApiCredentials credentials;

    SimplifiedStage(SdkAuth auth) {
        this.credentials = auth.credentials();
    }

    public SynchronousPromptStage explain(File image) {
        return this.ensureImageChooserStage().explain(image).analyze(DetailedAnalyze.HIGH).andRespond().immediate();
    }

    public SynchronousPromptStage explain(String urlOrBase64) {
        return this.ensureImageChooserStage().explain(urlOrBase64).analyze(DetailedAnalyze.HIGH).andRespond().immediate();
    }

    private ImageChooserStage ensureImageChooserStage() {
        return Vision.authenticate(new HttpExecutorContext(this.credentials)).understanding(new ObjectMapper()).poweredByGpt40Vision().limitResponseTo(300);
    }
}

