/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.voice.speech;

import bg.codexio.ai.openai.api.http.voice.SpeechHttpExecutor;
import bg.codexio.ai.openai.api.payload.Streamable;
import bg.codexio.ai.openai.api.payload.voice.request.SpeechRequest;
import bg.codexio.ai.openai.api.sdk.voice.speech.DownloadExecutor;
import bg.codexio.ai.openai.api.sdk.voice.speech.SpeechConfigurationStage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncPromiseStage
extends SpeechConfigurationStage {
    private final File targetFolder;
    private final Logger log;

    AsyncPromiseStage(SpeechHttpExecutor executor, SpeechRequest.Builder requestBuilder, File targetFolder, Logger log) {
        super(executor, requestBuilder);
        this.targetFolder = targetFolder;
        this.log = log;
    }

    AsyncPromiseStage(SpeechHttpExecutor executor, SpeechRequest.Builder requestBuilder, File targetFolder) {
        this(executor, requestBuilder, targetFolder, LoggerFactory.getLogger(AsyncPromiseStage.class));
    }

    public void then(Consumer<File> afterAll) {
        this.then(x -> {}, afterAll, error -> this.log.error("Download error.", error));
    }

    public void then(Consumer<File> afterAll, Consumer<Throwable> onError) {
        this.then(x -> {}, afterAll, onError);
    }

    public void onEachLine(Consumer<String> onEachLine) {
        this.then(onEachLine, x -> {}, error -> this.log.error("Download error.", error));
    }

    public void onEachLine(Consumer<String> onEachLine, Consumer<Throwable> onError) {
        this.then(onEachLine, x -> {}, onError);
    }

    public void then(Consumer<String> onEachLine, Consumer<File> afterAll, Consumer<Throwable> onError) {
        this.executor.executeAsync((Streamable)this.requestBuilder.build(), onEachLine, response -> CompletableFuture.supplyAsync(() -> {
            try {
                return DownloadExecutor.downloadTo(this.targetFolder, response, this.requestBuilder.responseFormat());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).whenComplete((result, error) -> {
            if (error != null) {
                onError.accept((Throwable)error);
            } else {
                afterAll.accept((File)result);
            }
        }));
    }

    File getTargetFolder() {
        return this.targetFolder;
    }
}

