/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.auth;

import bg.codexio.ai.openai.api.payload.credentials.ApiCredentials;
import bg.codexio.ai.openai.api.sdk.auth.SdkAuth;
import bg.codexio.ai.openai.api.sdk.auth.exception.NotValidAuthenticationMethod;
import bg.codexio.ai.openai.api.sdk.auth.util.StringUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FromJson
implements SdkAuth {
    public static final FromJson AUTH = new FromJson("openai-credentials.json", false);
    private final String jsonFile;
    private final boolean isFullPath;

    FromJson(String jsonFile, boolean isFullPath) {
        this.jsonFile = jsonFile;
        this.isFullPath = isFullPath;
    }

    public static FromJson resource(String resourceFileName) {
        return new FromJson(resourceFileName, false);
    }

    public static FromJson file(String fullPathFileName) {
        return new FromJson(fullPathFileName, true);
    }

    private static String extractValue(String json, String key) {
        Pattern pattern = Pattern.compile("\"" + key + "\"\\s*:\\s*\"([^\"]*)\"");
        Matcher matcher = pattern.matcher(json);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    @Override
    public ApiCredentials credentials() {
        String json = this.jsonContent();
        String apiKey = FromJson.extractValue(json, AvailableKeys.apiKey.name());
        if (StringUtil.isNullOrBlank(apiKey)) {
            throw new NotValidAuthenticationMethod("The given JSON file: " + this.jsonFile + " does not have a definition of the key \"" + AvailableKeys.apiKey.name() + "\".");
        }
        String orgId = FromJson.extractValue(json, AvailableKeys.orgId.name());
        if (StringUtil.isNullOrBlank(orgId)) {
            orgId = FromJson.extractValue(json, AvailableKeys.organizationId.name());
        }
        String baseUrl = FromJson.extractValue(json, AvailableKeys.baseUrl.name());
        return new ApiCredentials(apiKey, orgId, baseUrl);
    }

    private String jsonContent() {
        String string;
        block10: {
            InputStream stream = this.asInputStream();
            try {
                string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new NotValidAuthenticationMethod("Absolute file " + this.jsonFile + " not found.");
                }
                catch (IOException e) {
                    throw new NotValidAuthenticationMethod("Error reading the content of the " + (this.isFullPath ? "absolute " : "") + "file " + this.jsonFile);
                }
                catch (NullPointerException e) {
                    throw new NotValidAuthenticationMethod("Non-existing resource file: " + this.jsonFile);
                }
            }
            stream.close();
        }
        return string;
    }

    protected InputStream asInputStream() throws IOException {
        if (this.isFullPath) {
            return new FileInputStream(this.jsonFile);
        }
        return this.getClass().getClassLoader().getResourceAsStream(this.jsonFile);
    }

    public static enum AvailableKeys {
        apiKey,
        orgId,
        organizationId,
        baseUrl;

    }
}

