/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.images;

import bg.codexio.ai.openai.api.http.DefaultOpenAIHttpExecutor;
import bg.codexio.ai.openai.api.payload.images.Quality;
import bg.codexio.ai.openai.api.payload.images.request.ImageRequest;
import bg.codexio.ai.openai.api.payload.images.request.ImageRequestBuilder;
import bg.codexio.ai.openai.api.payload.images.response.ImageDataResponse;
import bg.codexio.ai.openai.api.sdk.IntermediateStage;
import bg.codexio.ai.openai.api.sdk.RuntimeSelectionStage;
import bg.codexio.ai.openai.api.sdk.images.Dalle3SizeStage;
import bg.codexio.ai.openai.api.sdk.images.ImageConfigurationStage;
import java.util.function.Function;

public class QualityStage<R extends ImageRequest, E extends RuntimeSelectionStage>
extends ImageConfigurationStage<R>
implements IntermediateStage {
    private final Function<ImageRequestBuilder<R>, E> runtimeSelector;

    QualityStage(DefaultOpenAIHttpExecutor<R, ImageDataResponse> executor, ImageRequestBuilder<R> builder, Function<ImageRequestBuilder<R>, E> runtimeSelector) {
        super(executor, builder);
        this.runtimeSelector = runtimeSelector;
    }

    public Dalle3SizeStage<R, E> highDefinitioned() {
        return this.withQuality(Quality.HIGH_QUALITY);
    }

    public Dalle3SizeStage<R, E> standardQuality() {
        return this.withQuality(Quality.STANDARD);
    }

    private Dalle3SizeStage<R, E> withQuality(Quality quality) {
        return new Dalle3SizeStage<R, E>(this.executor, this.builder.withQuality(quality.val()), this.runtimeSelector);
    }
}

