/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.images;

import bg.codexio.ai.openai.api.http.DefaultOpenAIHttpExecutor;
import bg.codexio.ai.openai.api.payload.Streamable;
import bg.codexio.ai.openai.api.payload.images.Format;
import bg.codexio.ai.openai.api.payload.images.request.ImageRequest;
import bg.codexio.ai.openai.api.payload.images.request.ImageRequestBuilder;
import bg.codexio.ai.openai.api.payload.images.response.ImageDataResponse;
import bg.codexio.ai.openai.api.sdk.RuntimeExecutor;
import bg.codexio.ai.openai.api.sdk.images.DownloadExecutor;
import bg.codexio.ai.openai.api.sdk.images.ImageConfigurationStage;
import java.io.File;
import java.io.IOException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveExecutor<R extends ImageRequest>
extends ImageConfigurationStage<R>
implements RuntimeExecutor {
    ReactiveExecutor(DefaultOpenAIHttpExecutor<R, ImageDataResponse> executor, ImageRequestBuilder<R> builder) {
        super(executor, builder);
    }

    public Mono<ImageDataResponse> get() {
        return this.executor.executeReactive((Streamable)((ImageRequest)this.builder.specificRequestCreator().apply(this.builder))).response();
    }

    public Flux<File> download(File targetFolder) {
        return this.executor.executeReactive((Streamable)((ImageRequest)this.builder.specificRequestCreator().apply(this.builder))).response().flatMapMany(response -> Flux.fromIterable((Iterable)response.data())).handle((image, sink) -> {
            try {
                sink.next((Object)DownloadExecutor.FromFile.downloadFile(targetFolder, Format.fromVal((String)this.builder.responseFormat()), image));
            }
            catch (IOException e) {
                sink.error((Throwable)new RuntimeException(e));
            }
        });
    }
}

