/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.images;

import bg.codexio.ai.openai.api.http.images.CreateImageHttpExecutor;
import bg.codexio.ai.openai.api.http.images.EditImageHttpExecutor;
import bg.codexio.ai.openai.api.http.images.ImageVariationHttpExecutor;
import bg.codexio.ai.openai.api.payload.images.request.CreateImageRequest;
import bg.codexio.ai.openai.api.payload.images.request.EditImageRequest;
import bg.codexio.ai.openai.api.payload.images.request.ImageRequest;
import bg.codexio.ai.openai.api.payload.images.request.ImageVariationRequest;
import bg.codexio.ai.openai.api.sdk.StartStage;
import bg.codexio.ai.openai.api.sdk.images.AIModelStage;
import bg.codexio.ai.openai.api.sdk.images.ChoicesStage;
import bg.codexio.ai.openai.api.sdk.images.CreatingActionTypeStage;
import bg.codexio.ai.openai.api.sdk.images.EditingActionTypeStage;
import bg.codexio.ai.openai.api.sdk.images.EditingMaskStage;
import bg.codexio.ai.openai.api.sdk.images.PromptfulImagesRuntimeSelectionStage;
import bg.codexio.ai.openai.api.sdk.images.PromptlessImagesRuntimeSelectionStage;
import bg.codexio.ai.openai.api.sdk.images.VariatingActionTypeStage;
import java.io.File;

public class ActionTypeStage<R extends ImageRequest>
implements StartStage {
    final CreateImageHttpExecutor createExecutor;
    final EditImageHttpExecutor editExecutor;
    final ImageVariationHttpExecutor variationExecutor;

    ActionTypeStage(CreateImageHttpExecutor createExecutor, EditImageHttpExecutor editExecutor, ImageVariationHttpExecutor variationExecutor) {
        this.createExecutor = createExecutor;
        this.editExecutor = editExecutor;
        this.variationExecutor = variationExecutor;
    }

    public AIModelStage<CreateImageRequest, PromptfulImagesRuntimeSelectionStage<CreateImageRequest>> creating() {
        return new CreatingActionTypeStage(this.createExecutor).creating();
    }

    public EditingMaskStage<EditImageRequest, PromptfulImagesRuntimeSelectionStage<EditImageRequest>> editing(File image) {
        return new EditingActionTypeStage(this.editExecutor).editing(image);
    }

    public ChoicesStage<ImageVariationRequest, PromptlessImagesRuntimeSelectionStage<ImageVariationRequest>> another(File image) {
        return new VariatingActionTypeStage(this.variationExecutor).another(image);
    }
}

