/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.chat;

import bg.codexio.ai.openai.api.http.HttpExecutorContext;
import bg.codexio.ai.openai.api.http.chat.ChatHttpExecutor;
import bg.codexio.ai.openai.api.payload.chat.request.ChatMessageRequest;
import bg.codexio.ai.openai.api.sdk.Authenticator;
import bg.codexio.ai.openai.api.sdk.HttpBuilder;
import bg.codexio.ai.openai.api.sdk.auth.SdkAuth;
import bg.codexio.ai.openai.api.sdk.chat.AIModelStage;
import bg.codexio.ai.openai.api.sdk.chat.ImmediateContextStage;
import bg.codexio.ai.openai.api.sdk.chat.SimplifiedStage;

public final class Chat {
    private Chat() {
    }

    public static AIModelStage throughHttp(ChatHttpExecutor httpExecutor) {
        return new AIModelStage(httpExecutor, ChatMessageRequest.builder());
    }

    public static HttpBuilder<AIModelStage> authenticate(HttpExecutorContext context) {
        return new HttpBuilder<AIModelStage>(context, (ctx, mapper) -> new AIModelStage(new ChatHttpExecutor(ctx, mapper), ChatMessageRequest.builder()));
    }

    public static HttpBuilder<AIModelStage> authenticate(SdkAuth auth) {
        return Chat.authenticate(new HttpExecutorContext(auth.credentials()));
    }

    public static ImmediateContextStage simply(SdkAuth auth) {
        return new SimplifiedStage(auth).simply();
    }

    public static ImmediateContextStage simply() {
        return Authenticator.autoAuthenticate(Chat::simply);
    }

    public static HttpBuilder<AIModelStage> defaults() {
        return Authenticator.autoAuthenticate(Chat::authenticate);
    }
}

