/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.images;

import bg.codexio.ai.openai.api.http.DefaultOpenAIHttpExecutor;
import bg.codexio.ai.openai.api.payload.images.Format;
import bg.codexio.ai.openai.api.payload.images.request.ImageRequest;
import bg.codexio.ai.openai.api.payload.images.request.ImageRequestBuilder;
import bg.codexio.ai.openai.api.payload.images.response.ImageDataResponse;
import bg.codexio.ai.openai.api.sdk.RuntimeExecutor;
import bg.codexio.ai.openai.api.sdk.images.DownloadExecutor;
import bg.codexio.ai.openai.api.sdk.images.ImageConfigurationStage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExecutor<R extends ImageRequest>
extends ImageConfigurationStage<R>
implements RuntimeExecutor {
    private final R imageRequest;
    private final Logger log = LoggerFactory.getLogger(AsyncExecutor.class);
    private final Consumer<String> onEachLine = x -> {};

    AsyncExecutor(DefaultOpenAIHttpExecutor<R, ImageDataResponse> executor, ImageRequestBuilder<R> builder) {
        super(executor, builder);
        this.imageRequest = (ImageRequest)this.builder.specificRequestCreator().apply(this.builder);
    }

    public void onResponse(Consumer<ImageDataResponse> callback) {
        this.executor.executeAsync(this.imageRequest, this.onEachLine, callback);
    }

    public void whenDownloaded(File targetFolder, Consumer<File[]> callback) {
        this.whenDownloaded(targetFolder, callback, error -> this.log.error("Download error occurred", error));
    }

    public void whenDownloaded(File targetFolder, Consumer<File[]> callback, Consumer<Throwable> errorHandler) {
        this.executor.executeAsync(this.imageRequest, this.onEachLine, response -> CompletableFuture.supplyAsync(() -> {
            try {
                return DownloadExecutor.FromResponse.downloadTo(targetFolder, response, Format.fromVal((String)this.builder.responseFormat()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).whenComplete((result, error) -> {
            if (error != null) {
                errorHandler.accept((Throwable)error);
            } else {
                callback.accept((File[])result);
            }
        }));
    }
}

