/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.images;

import bg.codexio.ai.openai.api.http.DefaultOpenAIHttpExecutor;
import bg.codexio.ai.openai.api.payload.images.request.ImageRequest;
import bg.codexio.ai.openai.api.payload.images.request.ImageRequestBuilder;
import bg.codexio.ai.openai.api.payload.images.response.ImageDataResponse;
import bg.codexio.ai.openai.api.sdk.IntermediateStage;
import bg.codexio.ai.openai.api.sdk.RuntimeSelectionStage;
import bg.codexio.ai.openai.api.sdk.images.AIModelStage;
import bg.codexio.ai.openai.api.sdk.images.ChoicesStage;
import bg.codexio.ai.openai.api.sdk.images.ImageConfigurationStage;
import bg.codexio.ai.openai.api.sdk.images.color.PopularColor;
import bg.codexio.ai.openai.api.sdk.images.tolerance.ColorDeviation;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.function.Function;
import javax.imageio.ImageIO;

public class EditingMaskStage<R extends ImageRequest, E extends RuntimeSelectionStage>
extends ImageConfigurationStage<R>
implements IntermediateStage {
    final Function<ImageRequestBuilder<R>, E> runtimeSelector;

    EditingMaskStage(DefaultOpenAIHttpExecutor<R, ImageDataResponse> executor, ImageRequestBuilder<R> builder, Function<ImageRequestBuilder<R>, E> runtimeSelector) {
        super(executor, builder);
        this.runtimeSelector = runtimeSelector;
    }

    protected static boolean areColorsSimilar(int left, int right, double tolerance) {
        Color c1 = new Color(left);
        Color c2 = new Color(right);
        int redDiff = Math.abs(c1.getRed() - c2.getRed());
        int greenDiff = Math.abs(c1.getGreen() - c2.getGreen());
        int blueDiff = Math.abs(c1.getBlue() - c2.getBlue());
        double maxDiff = 255.0 * tolerance;
        return (double)redDiff < maxDiff && (double)greenDiff < maxDiff && (double)blueDiff < maxDiff;
    }

    public ChoicesStage<R, E> unmasked() {
        return this.masked(PopularColor.WHITE);
    }

    public ChoicesStage<R, E> masked(File mask) {
        return new AIModelStage<R, E>(this.executor, this.builder.withMask(mask), this.runtimeSelector).poweredByDallE2();
    }

    public ChoicesStage<R, E> masked(int alphaZeroHex, ColorDeviation deviation) {
        BufferedImage image = this.asImage();
        if (!this.hasAlphaChannel(image)) {
            this.resetImageWithAlpha(image, alphaZeroHex, deviation.val());
        }
        return this.masked((File)null);
    }

    public ChoicesStage<R, E> masked(PopularColor color, ColorDeviation deviation) {
        return this.masked(color.val(), deviation);
    }

    public ChoicesStage<R, E> masked(PopularColor color) {
        return this.masked(color, ColorDeviation.THE_SAME);
    }

    public ChoicesStage<R, E> masked(int alphaZeroHex) {
        return this.masked(alphaZeroHex, ColorDeviation.THE_SAME);
    }

    public ChoicesStage<R, E> masked(int red, int green, int blue, ColorDeviation deviation) {
        return this.masked(red << 16 | green << 8 | blue, deviation);
    }

    public ChoicesStage<R, E> masked(int red, int green, int blue) {
        return this.masked(red, green, blue, ColorDeviation.THE_SAME);
    }

    public ChoicesStage<R, E> masked(String colorHex, ColorDeviation deviation) {
        String adaptedHex = colorHex.replace("#", "");
        if (adaptedHex.length() >= 8) {
            adaptedHex = adaptedHex.substring(2, 8);
        }
        return this.masked(Integer.parseInt(adaptedHex, 16), deviation);
    }

    public ChoicesStage<R, E> masked(String colorHex) {
        return this.masked(colorHex, ColorDeviation.THE_SAME);
    }

    public ChoicesStage<R, E> smallTransparency() {
        return this.masked(PopularColor.WHITE, ColorDeviation.SMALL_DIFFERENCE);
    }

    protected BufferedImage asImage() {
        try {
            return ImageIO.read(this.builder.image());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected BufferedImage withAlphaChannel(BufferedImage image, int alphaZeroHex, double deviation) {
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = image.getRGB(x, y);
                if (EditingMaskStage.areColorsSimilar(pixel, alphaZeroHex, deviation)) {
                    newImage.setRGB(x, y, alphaZeroHex & pixel);
                    continue;
                }
                newImage.setRGB(x, y, pixel);
            }
        }
        return newImage;
    }

    protected boolean hasAlphaChannel(BufferedImage image) {
        return image.getColorModel().hasAlpha();
    }

    protected void resetImageWithAlpha(BufferedImage image, int alphaZeroHex, double deviation) {
        try {
            File tempImage = File.createTempFile("rgba-", ".png");
            ImageIO.write((RenderedImage)this.withAlphaChannel(image, alphaZeroHex, deviation), "PNG", tempImage);
            this.builder = this.builder.withImage(tempImage);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

