/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.run;

import bg.codexio.ai.openai.api.http.run.RunnableHttpExecutor;
import bg.codexio.ai.openai.api.payload.run.request.RunnableRequest;
import bg.codexio.ai.openai.api.payload.run.response.RunnableResponse;
import bg.codexio.ai.openai.api.sdk.ObjectMapperSubtypesRegistrationUtils;
import bg.codexio.ai.openai.api.sdk.ThreadOperationUtils;
import bg.codexio.ai.openai.api.sdk.run.RunnableAdvancedConfigurationStage;
import bg.codexio.ai.openai.api.sdk.run.RunnableConfigurationStage;
import java.util.Objects;
import java.util.Optional;

public class RunnableResultStage
extends RunnableConfigurationStage {
    private final RunnableResponse run;

    RunnableResultStage(RunnableHttpExecutor httpExecutor, RunnableRequest.Builder requestBuilder, String threadId, RunnableResponse run) {
        super(httpExecutor, requestBuilder, threadId);
        this.run = run;
    }

    public RunnableResponse waitForCompletionRaw() {
        return this.sleepThenRefresh(this.run);
    }

    public RunnableResponse waitForCompletionRaw(RunnableResponse run) {
        return this.sleepThenRefresh(run);
    }

    public RunnableAdvancedConfigurationStage waitForCompletion() {
        return new RunnableAdvancedConfigurationStage(this.httpExecutor, this.requestBuilder, this.sleepThenRefresh(this.run).threadId());
    }

    public String waitForCompletion(RunnableResponse run) {
        return this.sleepThenRefresh(run).threadId();
    }

    public RunnableResponse from(String runnableId) {
        return (RunnableResponse)this.httpExecutor.executeWithPathVariables(new String[]{this.threadId, runnableId});
    }

    public RunnableResponse from(RunnableResponse runnableResponse) {
        if (!runnableResponse.tools().isEmpty()) {
            ObjectMapperSubtypesRegistrationUtils.registerAssistantTools(this.httpExecutor, runnableResponse.tools());
            return (RunnableResponse)this.httpExecutor.executeWithPathVariables(new String[]{runnableResponse.threadId(), runnableResponse.id()});
        }
        return (RunnableResponse)this.httpExecutor.executeWithPathVariables(new String[]{runnableResponse.threadId(), runnableResponse.id()});
    }

    public RunnableResponse from(String threadId, String runnableId) {
        return (RunnableResponse)this.httpExecutor.executeWithPathVariables(new String[]{threadId, runnableId});
    }

    private RunnableResponse sleepThenRefresh(RunnableResponse run) {
        while (Objects.equals(run.status(), "queued") || Objects.equals(run.status(), "in_progress")) {
            try {
                ThreadOperationUtils.sleep(this.getCompletionSleepDuration());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            run = this.from(run);
        }
        return run;
    }

    private Long getCompletionSleepDuration() {
        return Optional.ofNullable(System.getenv("COMPLETION_SLEEP_DURATION_MILLIS")).map(Long::valueOf).orElse(1000L);
    }
}

