/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.ai.openai.api.sdk.voice.speech;

import bg.codexio.ai.openai.api.http.HttpExecutorContext;
import bg.codexio.ai.openai.api.http.voice.SpeechHttpExecutor;
import bg.codexio.ai.openai.api.payload.voice.request.SpeechRequest;
import bg.codexio.ai.openai.api.sdk.Authenticator;
import bg.codexio.ai.openai.api.sdk.HttpBuilder;
import bg.codexio.ai.openai.api.sdk.auth.SdkAuth;
import bg.codexio.ai.openai.api.sdk.voice.speech.AIModelStage;
import bg.codexio.ai.openai.api.sdk.voice.speech.SimplifiedStage;
import bg.codexio.ai.openai.api.sdk.voice.speech.SynchronousPromptStage;

public final class Speech {
    private Speech() {
    }

    public static AIModelStage throughHttp(SpeechHttpExecutor executor) {
        return new AIModelStage(executor, SpeechRequest.builder());
    }

    public static HttpBuilder<AIModelStage> authenticate(HttpExecutorContext context) {
        return new HttpBuilder<AIModelStage>(context, (ctx, mapper) -> new AIModelStage(new SpeechHttpExecutor(ctx, mapper), SpeechRequest.builder()));
    }

    public static HttpBuilder<AIModelStage> authenticate(SdkAuth auth) {
        return Speech.authenticate(new HttpExecutorContext(auth.credentials()));
    }

    public static SynchronousPromptStage simply(SdkAuth auth) {
        return new SimplifiedStage(auth.credentials()).andRespond().immediate();
    }

    public static SynchronousPromptStage simply() {
        return Authenticator.autoAuthenticate(Speech::simply);
    }

    public static HttpBuilder<AIModelStage> defaults() {
        return Authenticator.autoAuthenticate(Speech::authenticate);
    }
}

