/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.springframework.boot.autoconfigure.property;

import bg.codexio.ai.openai.api.payload.environment.AvailableEnvironmentVariables;
import bg.codexio.springframework.boot.autoconfigure.property.OpenAIProperties;
import bg.codexio.springframework.boot.autoconfigure.property.PropertyAware;
import java.util.Objects;
import org.springframework.boot.logging.LogLevel;

public class EnvironmentPropertyAware
implements PropertyAware {
    private final OpenAIProperties properties;

    @Override
    public String getProperty(String key) {
        return switch (AvailableEnvironmentVariables.valueOf((String)key)) {
            default -> throw new MatchException(null, null);
            case AvailableEnvironmentVariables.OPENAI_API_BASE_URL -> this.properties.getBaseUrl();
            case AvailableEnvironmentVariables.OPENAI_ORG_ID -> this.properties.getOrganizationId();
            case AvailableEnvironmentVariables.OPENAI_API_KEY -> this.properties.getApiKey();
            case AvailableEnvironmentVariables.OPENAI_LOGGING_ENABLED -> {
                if (this.properties.getLogging().isEnabled()) {
                    yield "true";
                }
                yield null;
            }
            case AvailableEnvironmentVariables.OPENAI_LOGGING_LEVEL -> String.valueOf(Objects.requireNonNullElse(this.properties.getLogging().getLevel(), LogLevel.DEBUG));
        };
    }

    public EnvironmentPropertyAware(OpenAIProperties properties) {
        this.properties = properties;
    }
}

