/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.springframework.boot.autoconfigure.property;

import bg.codexio.ai.openai.api.sdk.auth.SdkAuth;
import bg.codexio.springframework.boot.autoconfigure.auth.FromProperties;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.logging.LogLevel;

@ConfigurationProperties(prefix="codexio.openai")
public class OpenAIProperties {
    private Class<? extends SdkAuth> authType = FromProperties.class;
    private String apiKey;
    private String organizationId = "";
    private String baseUrl = "https://api.openai.com/v1";
    private OpenAILoggingProperties logging = new OpenAILoggingProperties();
    private OpenAIHttpProperties http = new OpenAIHttpProperties();

    public Class<? extends SdkAuth> getAuthType() {
        return this.authType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public OpenAILoggingProperties getLogging() {
        return this.logging;
    }

    public OpenAIHttpProperties getHttp() {
        return this.http;
    }

    public void setAuthType(Class<? extends SdkAuth> authType) {
        this.authType = authType;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setLogging(OpenAILoggingProperties logging) {
        this.logging = logging;
    }

    public void setHttp(OpenAIHttpProperties http) {
        this.http = http;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenAIProperties)) {
            return false;
        }
        OpenAIProperties other = (OpenAIProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<? extends SdkAuth> this$authType = this.getAuthType();
        Class<? extends SdkAuth> other$authType = other.getAuthType();
        if (this$authType == null ? other$authType != null : !this$authType.equals(other$authType)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        OpenAILoggingProperties this$logging = this.getLogging();
        OpenAILoggingProperties other$logging = other.getLogging();
        if (this$logging == null ? other$logging != null : !((Object)this$logging).equals(other$logging)) {
            return false;
        }
        OpenAIHttpProperties this$http = this.getHttp();
        OpenAIHttpProperties other$http = other.getHttp();
        return !(this$http == null ? other$http != null : !((Object)this$http).equals(other$http));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenAIProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<? extends SdkAuth> $authType = this.getAuthType();
        result = result * 59 + ($authType == null ? 43 : $authType.hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        OpenAILoggingProperties $logging = this.getLogging();
        result = result * 59 + ($logging == null ? 43 : ((Object)$logging).hashCode());
        OpenAIHttpProperties $http = this.getHttp();
        result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
        return result;
    }

    public String toString() {
        return "OpenAIProperties(authType=" + String.valueOf(this.getAuthType()) + ", apiKey=" + this.getApiKey() + ", organizationId=" + this.getOrganizationId() + ", baseUrl=" + this.getBaseUrl() + ", logging=" + String.valueOf(this.getLogging()) + ", http=" + String.valueOf(this.getHttp()) + ")";
    }

    public static class OpenAILoggingProperties {
        private boolean enabled;
        private LogLevel level;

        public boolean isEnabled() {
            return this.enabled;
        }

        public LogLevel getLevel() {
            return this.level;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setLevel(LogLevel level) {
            this.level = level;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OpenAILoggingProperties)) {
                return false;
            }
            OpenAILoggingProperties other = (OpenAILoggingProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            LogLevel this$level = this.getLevel();
            LogLevel other$level = other.getLevel();
            return !(this$level == null ? other$level != null : !this$level.equals(other$level));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OpenAILoggingProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            LogLevel $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : $level.hashCode());
            return result;
        }

        public String toString() {
            return "OpenAIProperties.OpenAILoggingProperties(enabled=" + this.isEnabled() + ", level=" + String.valueOf(this.getLevel()) + ")";
        }
    }

    public static class OpenAIHttpProperties {
        private OpenAIHttpTimeouts timeouts = new OpenAIHttpTimeouts();
        private OpenAIHttpConnectionPool connectionPool = new OpenAIHttpConnectionPool();

        public OpenAIHttpTimeouts getTimeouts() {
            return this.timeouts;
        }

        public OpenAIHttpConnectionPool getConnectionPool() {
            return this.connectionPool;
        }

        public void setTimeouts(OpenAIHttpTimeouts timeouts) {
            this.timeouts = timeouts;
        }

        public void setConnectionPool(OpenAIHttpConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OpenAIHttpProperties)) {
                return false;
            }
            OpenAIHttpProperties other = (OpenAIHttpProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            OpenAIHttpTimeouts this$timeouts = this.getTimeouts();
            OpenAIHttpTimeouts other$timeouts = other.getTimeouts();
            if (this$timeouts == null ? other$timeouts != null : !((Object)this$timeouts).equals(other$timeouts)) {
                return false;
            }
            OpenAIHttpConnectionPool this$connectionPool = this.getConnectionPool();
            OpenAIHttpConnectionPool other$connectionPool = other.getConnectionPool();
            return !(this$connectionPool == null ? other$connectionPool != null : !((Object)this$connectionPool).equals(other$connectionPool));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OpenAIHttpProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            OpenAIHttpTimeouts $timeouts = this.getTimeouts();
            result = result * 59 + ($timeouts == null ? 43 : ((Object)$timeouts).hashCode());
            OpenAIHttpConnectionPool $connectionPool = this.getConnectionPool();
            result = result * 59 + ($connectionPool == null ? 43 : ((Object)$connectionPool).hashCode());
            return result;
        }

        public String toString() {
            return "OpenAIProperties.OpenAIHttpProperties(timeouts=" + String.valueOf(this.getTimeouts()) + ", connectionPool=" + String.valueOf(this.getConnectionPool()) + ")";
        }

        public static class OpenAIHttpTimeouts {
            private OpenAIHttpDuration call = new OpenAIHttpDuration();
            private OpenAIHttpDuration connect = new OpenAIHttpDuration();
            private OpenAIHttpDuration read = new OpenAIHttpDuration();

            public OpenAIHttpDuration getCall() {
                return this.call;
            }

            public OpenAIHttpDuration getConnect() {
                return this.connect;
            }

            public OpenAIHttpDuration getRead() {
                return this.read;
            }

            public void setCall(OpenAIHttpDuration call) {
                this.call = call;
            }

            public void setConnect(OpenAIHttpDuration connect) {
                this.connect = connect;
            }

            public void setRead(OpenAIHttpDuration read) {
                this.read = read;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OpenAIHttpTimeouts)) {
                    return false;
                }
                OpenAIHttpTimeouts other = (OpenAIHttpTimeouts)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                OpenAIHttpDuration this$call = this.getCall();
                OpenAIHttpDuration other$call = other.getCall();
                if (this$call == null ? other$call != null : !((Object)this$call).equals(other$call)) {
                    return false;
                }
                OpenAIHttpDuration this$connect = this.getConnect();
                OpenAIHttpDuration other$connect = other.getConnect();
                if (this$connect == null ? other$connect != null : !((Object)this$connect).equals(other$connect)) {
                    return false;
                }
                OpenAIHttpDuration this$read = this.getRead();
                OpenAIHttpDuration other$read = other.getRead();
                return !(this$read == null ? other$read != null : !((Object)this$read).equals(other$read));
            }

            protected boolean canEqual(Object other) {
                return other instanceof OpenAIHttpTimeouts;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                OpenAIHttpDuration $call = this.getCall();
                result = result * 59 + ($call == null ? 43 : ((Object)$call).hashCode());
                OpenAIHttpDuration $connect = this.getConnect();
                result = result * 59 + ($connect == null ? 43 : ((Object)$connect).hashCode());
                OpenAIHttpDuration $read = this.getRead();
                result = result * 59 + ($read == null ? 43 : ((Object)$read).hashCode());
                return result;
            }

            public String toString() {
                return "OpenAIProperties.OpenAIHttpProperties.OpenAIHttpTimeouts(call=" + String.valueOf(this.getCall()) + ", connect=" + String.valueOf(this.getConnect()) + ", read=" + String.valueOf(this.getRead()) + ")";
            }
        }

        public static class OpenAIHttpConnectionPool {
            private int maxIdleConnections = 3;
            private OpenAIHttpDuration keepAlive = new OpenAIHttpDuration();

            public int getMaxIdleConnections() {
                return this.maxIdleConnections;
            }

            public OpenAIHttpDuration getKeepAlive() {
                return this.keepAlive;
            }

            public void setMaxIdleConnections(int maxIdleConnections) {
                this.maxIdleConnections = maxIdleConnections;
            }

            public void setKeepAlive(OpenAIHttpDuration keepAlive) {
                this.keepAlive = keepAlive;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OpenAIHttpConnectionPool)) {
                    return false;
                }
                OpenAIHttpConnectionPool other = (OpenAIHttpConnectionPool)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getMaxIdleConnections() != other.getMaxIdleConnections()) {
                    return false;
                }
                OpenAIHttpDuration this$keepAlive = this.getKeepAlive();
                OpenAIHttpDuration other$keepAlive = other.getKeepAlive();
                return !(this$keepAlive == null ? other$keepAlive != null : !((Object)this$keepAlive).equals(other$keepAlive));
            }

            protected boolean canEqual(Object other) {
                return other instanceof OpenAIHttpConnectionPool;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getMaxIdleConnections();
                OpenAIHttpDuration $keepAlive = this.getKeepAlive();
                result = result * 59 + ($keepAlive == null ? 43 : ((Object)$keepAlive).hashCode());
                return result;
            }

            public String toString() {
                return "OpenAIProperties.OpenAIHttpProperties.OpenAIHttpConnectionPool(maxIdleConnections=" + this.getMaxIdleConnections() + ", keepAlive=" + String.valueOf(this.getKeepAlive()) + ")";
            }
        }

        public static class OpenAIHttpDuration {
            private long period = 1L;
            private TimeUnit timeUnit = TimeUnit.MINUTES;

            public long getPeriod() {
                return this.period;
            }

            public TimeUnit getTimeUnit() {
                return this.timeUnit;
            }

            public void setPeriod(long period) {
                this.period = period;
            }

            public void setTimeUnit(TimeUnit timeUnit) {
                this.timeUnit = timeUnit;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OpenAIHttpDuration)) {
                    return false;
                }
                OpenAIHttpDuration other = (OpenAIHttpDuration)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getPeriod() != other.getPeriod()) {
                    return false;
                }
                TimeUnit this$timeUnit = this.getTimeUnit();
                TimeUnit other$timeUnit = other.getTimeUnit();
                return !(this$timeUnit == null ? other$timeUnit != null : !((Object)((Object)this$timeUnit)).equals((Object)other$timeUnit));
            }

            protected boolean canEqual(Object other) {
                return other instanceof OpenAIHttpDuration;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $period = this.getPeriod();
                result = result * 59 + (int)($period >>> 32 ^ $period);
                TimeUnit $timeUnit = this.getTimeUnit();
                result = result * 59 + ($timeUnit == null ? 43 : ((Object)((Object)$timeUnit)).hashCode());
                return result;
            }

            public String toString() {
                return "OpenAIProperties.OpenAIHttpProperties.OpenAIHttpDuration(period=" + this.getPeriod() + ", timeUnit=" + String.valueOf((Object)this.getTimeUnit()) + ")";
            }
        }
    }
}

