/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.springframework.boot;

import bg.codexio.springframework.boot.AdapterProperties;
import bg.codexio.springframework.boot.RequeryProperties;
import bg.codexio.springframework.data.jpa.requery.adapter.HttpFilterAdapter;
import bg.codexio.springframework.data.jpa.requery.adapter.JsonHttpFilterAdapter;
import bg.codexio.springframework.data.jpa.requery.config.FilterJsonTypeConverter;
import bg.codexio.springframework.data.jpa.requery.config.FilterJsonTypeConverterImpl;
import bg.codexio.springframework.data.jpa.requery.resolver.FilterJsonArgumentResolver;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties
public class FilterJsonAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Bean
    public HttpFilterAdapter httpFilterAdapter() {
        return new JsonHttpFilterAdapter(this.objectMapper());
    }

    @Bean
    public FilterJsonTypeConverter filterJsonTypeConverter() {
        return new FilterJsonTypeConverterImpl();
    }

    @Bean
    public AdapterProperties adapterProperties() {
        return new AdapterProperties();
    }

    @Bean
    public RequeryProperties requeryProperties(List<HttpFilterAdapter> availableAdapters) {
        return new RequeryProperties(this.adapterProperties(), availableAdapters);
    }

    @Bean
    public FilterJsonArgumentResolver filterJsonArgumentResolver(RequeryProperties requeryProperties, FilterJsonTypeConverter converter) {
        return new FilterJsonArgumentResolver(converter, requeryProperties.getActiveAdapters());
    }
}

