/*
 * Decompiled with CFR 0.152.
 */
package bg.codexio.springframework.boot;

import bg.codexio.springframework.boot.AdapterProperties;
import bg.codexio.springframework.data.jpa.requery.adapter.HttpFilterAdapter;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RequeryProperties {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<HttpFilterAdapter> activeAdapters;

    public RequeryProperties(AdapterProperties adapters, List<HttpFilterAdapter> availableAdapters) {
        this.activeAdapters = adapters.getActive() == null || adapters.getActive().isEmpty() ? availableAdapters : availableAdapters.stream().filter(adapter -> adapters.getActive().contains(adapter.getClass().getSimpleName())).collect(Collectors.toList());
        for (HttpFilterAdapter activeAdapter : this.activeAdapters) {
            this.logger.info("{} has been registered as an active adapter", (Object)activeAdapter.getClass().getSimpleName());
        }
    }

    public List<HttpFilterAdapter> getActiveAdapters() {
        return this.activeAdapters;
    }
}

