/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.metrics.core.autoconfigure;

import box.tapsi.libs.metrics.core.TapsiMetricProperties;
import box.tapsi.libs.metrics.core.services.MeterRegistryService;
import box.tapsi.libs.metrics.core.services.MeterRegistryServiceImpl;
import io.micrometer.core.aop.TimedAspect;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.aop.ObservedAspect;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

@ConditionalOnClass(value={MeterRegistry.class})
@EnableConfigurationProperties(value={TapsiMetricProperties.class})
@AutoConfiguration(after={CompositeMeterRegistryAutoConfiguration.class})
@ComponentScan(value={"box.tapsi.libs.metrics.core"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\r"}, d2={"Lbox/tapsi/libs/metrics/core/autoconfigure/TapsiMetricsAutoConfiguration;", "", "()V", "meterRegistryService", "Lbox/tapsi/libs/metrics/core/services/MeterRegistryService;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "observedAspect", "Lio/micrometer/observation/aop/ObservedAspect;", "observationRegistry", "Lio/micrometer/observation/ObservationRegistry;", "timedAspect", "Lio/micrometer/core/aop/TimedAspect;", "metrics-core"})
public class TapsiMetricsAutoConfiguration {
    @ConditionalOnMissingBean(value={TimedAspect.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    @Bean
    @NotNull
    public TimedAspect timedAspect(@NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        return new TimedAspect(meterRegistry);
    }

    @ConditionalOnMissingBean(value={ObservedAspect.class})
    @ConditionalOnBean(value={ObservationRegistry.class})
    @Bean
    @NotNull
    public ObservedAspect observedAspect(@NotNull ObservationRegistry observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)observationRegistry, (String)"observationRegistry");
        return new ObservedAspect(observationRegistry);
    }

    @ConditionalOnMissingBean(value={MeterRegistryService.class})
    @ConditionalOnBean(value={MeterRegistry.class})
    @Bean
    @NotNull
    public MeterRegistryService meterRegistryService(@NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        return new MeterRegistryServiceImpl(meterRegistry);
    }
}

