/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.metrics.core.aop;

import box.tapsi.libs.metrics.core.TapsiMetricProperties;
import box.tapsi.libs.metrics.core.annotations.ReactiveTimed;
import box.tapsi.libs.metrics.core.services.MeterRegistryService;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Aspect
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u000e\u001a\u00020\b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010H\u0012J\b\u0010\u0011\u001a\u00020\u0012H\u0016J7\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001aH\u0012\u00a2\u0006\u0002\u0010\u001bJ\"\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0012\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lbox/tapsi/libs/metrics/core/aop/ReactiveTimedAspect;", "Lorg/springframework/core/Ordered;", "meterRegistryService", "Lbox/tapsi/libs/metrics/core/services/MeterRegistryService;", "tapsiMetricProperties", "Lbox/tapsi/libs/metrics/core/TapsiMetricProperties;", "(Lbox/tapsi/libs/metrics/core/services/MeterRegistryService;Lbox/tapsi/libs/metrics/core/TapsiMetricProperties;)V", "defaultMetricName", "", "getDefaultMetricName", "()Ljava/lang/String;", "applyReactiveMetrics", "Lreactor/core/CorePublisher;", "result", "name", "tags", "", "getOrder", "", "getTags", "", "joinPoint", "Lorg/aspectj/lang/ProceedingJoinPoint;", "method", "Ljava/lang/reflect/Method;", "extraTags", "", "(Lorg/aspectj/lang/ProceedingJoinPoint;Ljava/lang/reflect/Method;[Ljava/lang/String;)Ljava/util/Map;", "perform", "", "reactiveTimedAnnotation", "Lbox/tapsi/libs/metrics/core/annotations/ReactiveTimed;", "reactiveTimedClass", "reactiveTimedMethod", "metrics-core"})
@SourceDebugExtension(value={"SMAP\nReactiveTimedAspect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactiveTimedAspect.kt\nbox/tapsi/libs/metrics/core/aop/ReactiveTimedAspect\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,127:1\n1#2:128\n215#3,2:129\n*S KotlinDebug\n*F\n+ 1 ReactiveTimedAspect.kt\nbox/tapsi/libs/metrics/core/aop/ReactiveTimedAspect\n*L\n92#1:129,2\n*E\n"})
public class ReactiveTimedAspect
implements Ordered {
    @NotNull
    private final MeterRegistryService meterRegistryService;
    @NotNull
    private final TapsiMetricProperties tapsiMetricProperties;
    @NotNull
    private final String defaultMetricName;

    public ReactiveTimedAspect(@NotNull MeterRegistryService meterRegistryService, @NotNull TapsiMetricProperties tapsiMetricProperties) {
        Intrinsics.checkNotNullParameter((Object)meterRegistryService, (String)"meterRegistryService");
        Intrinsics.checkNotNullParameter((Object)tapsiMetricProperties, (String)"tapsiMetricProperties");
        this.meterRegistryService = meterRegistryService;
        this.tapsiMetricProperties = tapsiMetricProperties;
        this.defaultMetricName = "reactive.method.timed";
    }

    @NotNull
    public String getDefaultMetricName() {
        return this.defaultMetricName;
    }

    public int getOrder() {
        return this.tapsiMetricProperties.getReactiveTimed().getOrder();
    }

    @Around(value="@within(box.tapsi.libs.metrics.core.annotations.ReactiveTimed)&& !@annotation(box.tapsi.libs.metrics.core.annotations.ReactiveTimed)")
    @Nullable
    public Object reactiveTimedClass(@NotNull ProceedingJoinPoint joinPoint) {
        Intrinsics.checkNotNullParameter((Object)joinPoint, (String)"joinPoint");
        Signature signature = joinPoint.getSignature();
        Intrinsics.checkNotNull((Object)signature, (String)"null cannot be cast to non-null type org.aspectj.lang.reflect.MethodSignature");
        Method method = ((MethodSignature)signature).getMethod();
        Method method2 = AopUtils.getMostSpecificMethod((Method)method, joinPoint.getTarget().getClass());
        Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"getMostSpecificMethod(...)");
        Method targetMethod = method2;
        Class<?> declaringClass = targetMethod.getDeclaringClass();
        ReactiveTimed reactiveTimed = (ReactiveTimed)AnnotationUtils.findAnnotation(declaringClass, ReactiveTimed.class);
        if (reactiveTimed == null) {
            return joinPoint.proceed();
        }
        ReactiveTimed reactiveTimedAnnotation = reactiveTimed;
        return this.perform(joinPoint, reactiveTimedAnnotation, targetMethod);
    }

    @Around(value="execution (@box.tapsi.libs.metrics.core.annotations.ReactiveTimed * *.*(..))")
    @Nullable
    public Object reactiveTimedMethod(@NotNull ProceedingJoinPoint joinPoint) {
        Intrinsics.checkNotNullParameter((Object)joinPoint, (String)"joinPoint");
        Signature signature = joinPoint.getSignature();
        Intrinsics.checkNotNull((Object)signature, (String)"null cannot be cast to non-null type org.aspectj.lang.reflect.MethodSignature");
        Method method = ((MethodSignature)signature).getMethod();
        Method method2 = AopUtils.getMostSpecificMethod((Method)method, joinPoint.getTarget().getClass());
        Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"getMostSpecificMethod(...)");
        Method targetMethod = method2;
        ReactiveTimed reactiveTimed = (ReactiveTimed)AnnotationUtils.findAnnotation((Method)targetMethod, ReactiveTimed.class);
        if (reactiveTimed == null) {
            return joinPoint.proceed();
        }
        ReactiveTimed reactiveTimedAnnotation = reactiveTimed;
        return this.perform(joinPoint, reactiveTimedAnnotation, targetMethod);
    }

    @Nullable
    public Object perform(@NotNull ProceedingJoinPoint joinPoint, @NotNull ReactiveTimed reactiveTimedAnnotation, @NotNull Method method) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)joinPoint, (String)"joinPoint");
        Intrinsics.checkNotNullParameter((Object)reactiveTimedAnnotation, (String)"reactiveTimedAnnotation");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Object result = joinPoint.proceed();
        CharSequence charSequence2 = reactiveTimedAnnotation.name();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = this.getDefaultMetricName();
        } else {
            charSequence = charSequence2;
        }
        String name = (String)charSequence;
        String[] extraTags = reactiveTimedAnnotation.extraTags();
        Map<String, String> tags = this.getTags(joinPoint, method, extraTags);
        if (!(result instanceof CorePublisher)) {
            return result;
        }
        return this.applyReactiveMetrics((CorePublisher)result, name, tags);
    }

    private Map<String, String> getTags(ProceedingJoinPoint joinPoint, Method method, String[] extraTags) {
        Object object;
        String string;
        Map map;
        Map tags = new LinkedHashMap();
        if (this.tapsiMetricProperties.getReactiveTimed().getIncludeClassName()) {
            map = tags;
            string = "class";
            String string2 = joinPoint.getTarget().getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            object = string2;
            map.put(string, object);
        }
        if (this.tapsiMetricProperties.getReactiveTimed().getIncludeMethodName()) {
            map = tags;
            string = "method";
            String string3 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            object = string3;
            map.put(string, object);
        }
        Map<String, String> $this$forEach$iv = this.tapsiMetricProperties.getReactiveTimed().getDefaultTags();
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            tags.put(key, value);
        }
        map = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(extraTags.length - 1))), (int)2);
        int i = map.getFirst();
        int n = map.getLast();
        int n2 = map.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                tags.put(extraTags[i], extraTags[i + 1]);
                if (i == n) break;
                i += n2;
            }
        }
        return tags;
    }

    private CorePublisher<?> applyReactiveMetrics(CorePublisher<?> result, String name, Map<String, String> tags) {
        CorePublisher corePublisher;
        CorePublisher corePublisher2 = result;
        if (corePublisher2 instanceof Mono) {
            Mono mono = ((Mono)result).name(name);
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"name(...)");
            Mono unRecordedResult = mono;
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                Intrinsics.checkNotNullExpressionValue((Object)unRecordedResult.tag(entry.getKey(), entry.getValue()), (String)"tag(...)");
            }
            Object object = unRecordedResult.as(arg_0 -> ReactiveTimedAspect.applyReactiveMetrics$lambda$2((Function1)new Function1<Mono<Object>, Mono<Object>>((Object)this.meterRegistryService){

                @NotNull
                public final Mono<Object> invoke(@NotNull Mono<Object> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    return ((MeterRegistryService)this.receiver).tap(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)object);
            corePublisher = (CorePublisher)object;
        } else if (corePublisher2 instanceof Flux) {
            Flux flux = ((Flux)result).name(name);
            Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"name(...)");
            Flux unRecordedResult = flux;
            for (Map.Entry entry : tags.entrySet()) {
                Intrinsics.checkNotNullExpressionValue((Object)unRecordedResult.tag((String)entry.getKey(), (String)entry.getValue()), (String)"tag(...)");
            }
            Object object = unRecordedResult.as(arg_0 -> ReactiveTimedAspect.applyReactiveMetrics$lambda$3((Function1)new Function1<Flux<Object>, Flux<Object>>((Object)this.meterRegistryService){

                @NotNull
                public final Flux<Object> invoke(@NotNull Flux<Object> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    return ((MeterRegistryService)this.receiver).tap(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)object);
            corePublisher = (CorePublisher)object;
        } else {
            corePublisher = result;
        }
        return corePublisher;
    }

    private static final Mono applyReactiveMetrics$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Flux applyReactiveMetrics$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Flux)$tmp0.invoke(p0);
    }
}

