/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.quartz;

import box.tapsi.libs.utilities.time.TimeExtensionsKt;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.quartz.CronScheduleBuilder;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH&R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lbox/tapsi/libs/scheduler/quartz/QuartzTriggerBuilder;", "", "triggerName", "", "triggerGroup", "startTime", "Ljava/time/Instant;", "(Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;)V", "getStartTime", "()Ljava/time/Instant;", "getTriggerGroup", "()Ljava/lang/String;", "getTriggerName", "build", "Lorg/quartz/Trigger;", "Cron", "Simple", "Lbox/tapsi/libs/scheduler/quartz/QuartzTriggerBuilder$Cron;", "Lbox/tapsi/libs/scheduler/quartz/QuartzTriggerBuilder$Simple;", "scheduler-starter"})
public abstract sealed class QuartzTriggerBuilder {
    @NotNull
    private final String triggerName;
    @NotNull
    private final String triggerGroup;
    @NotNull
    private final Instant startTime;

    private QuartzTriggerBuilder(String triggerName, String triggerGroup, Instant startTime) {
        this.triggerName = triggerName;
        this.triggerGroup = triggerGroup;
        this.startTime = startTime;
    }

    @NotNull
    public final String getTriggerName() {
        return this.triggerName;
    }

    @NotNull
    public final String getTriggerGroup() {
        return this.triggerGroup;
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    @NotNull
    public abstract Trigger build();

    public /* synthetic */ QuartzTriggerBuilder(String triggerName, String triggerGroup, Instant startTime, DefaultConstructorMarker $constructor_marker) {
        this(triggerName, triggerGroup, startTime);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lbox/tapsi/libs/scheduler/quartz/QuartzTriggerBuilder$Cron;", "Lbox/tapsi/libs/scheduler/quartz/QuartzTriggerBuilder;", "triggerName", "", "triggerGroup", "startTime", "Ljava/time/Instant;", "cronExpression", "(Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;Ljava/lang/String;)V", "getCronExpression", "()Ljava/lang/String;", "build", "Lorg/quartz/Trigger;", "scheduler-starter"})
    public static final class Cron
    extends QuartzTriggerBuilder {
        @NotNull
        private final String cronExpression;

        public Cron(@NotNull String triggerName, @NotNull String triggerGroup, @NotNull Instant startTime, @NotNull String cronExpression) {
            Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
            Intrinsics.checkNotNullParameter((Object)triggerGroup, (String)"triggerGroup");
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            Intrinsics.checkNotNullParameter((Object)cronExpression, (String)"cronExpression");
            super(triggerName, triggerGroup, startTime, null);
            this.cronExpression = cronExpression;
        }

        @NotNull
        public final String getCronExpression() {
            return this.cronExpression;
        }

        @Override
        @NotNull
        public Trigger build() {
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.getTriggerName(), this.getTriggerGroup()).startAt(TimeExtensionsKt.toDate((Instant)this.getStartTime())).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cronExpression)).build();
            Intrinsics.checkNotNullExpressionValue((Object)trigger, (String)"build(...)");
            return trigger;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lbox/tapsi/libs/scheduler/quartz/QuartzTriggerBuilder$Simple;", "Lbox/tapsi/libs/scheduler/quartz/QuartzTriggerBuilder;", "triggerName", "", "triggerGroup", "startTime", "Ljava/time/Instant;", "repeatInterval", "", "repeatCount", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;JI)V", "getRepeatCount", "()I", "getRepeatInterval", "()J", "build", "Lorg/quartz/Trigger;", "scheduler-starter"})
    public static final class Simple
    extends QuartzTriggerBuilder {
        private final long repeatInterval;
        private final int repeatCount;

        public Simple(@NotNull String triggerName, @NotNull String triggerGroup, @NotNull Instant startTime, long repeatInterval, int repeatCount) {
            Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
            Intrinsics.checkNotNullParameter((Object)triggerGroup, (String)"triggerGroup");
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            super(triggerName, triggerGroup, startTime, null);
            this.repeatInterval = repeatInterval;
            this.repeatCount = repeatCount;
        }

        public final long getRepeatInterval() {
            return this.repeatInterval;
        }

        public final int getRepeatCount() {
            return this.repeatCount;
        }

        @Override
        @NotNull
        public Trigger build() {
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.getTriggerName(), this.getTriggerGroup()).startAt(TimeExtensionsKt.toDate((Instant)this.getStartTime())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.repeatInterval).withRepeatCount(this.repeatCount)).build();
            Intrinsics.checkNotNullExpressionValue((Object)trigger, (String)"build(...)");
            return trigger;
        }
    }
}

