/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.quartz.metric.listeners;

import box.tapsi.libs.scheduler.quartz.annotations.TriggerListener;
import box.tapsi.libs.scheduler.quartz.metric.registry.QuartzRegistry;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;

@TriggerListener
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u0012\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u0013\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lbox/tapsi/libs/scheduler/quartz/metric/listeners/QuartzMisfireTriggerListener;", "Lorg/quartz/TriggerListener;", "quartzRegistry", "Lbox/tapsi/libs/scheduler/quartz/metric/registry/QuartzRegistry;", "logger", "Lorg/slf4j/Logger;", "(Lbox/tapsi/libs/scheduler/quartz/metric/registry/QuartzRegistry;Lorg/slf4j/Logger;)V", "getName", "", "triggerComplete", "", "trigger", "Lorg/quartz/Trigger;", "context", "Lorg/quartz/JobExecutionContext;", "triggerInstructionCode", "Lorg/quartz/Trigger$CompletedExecutionInstruction;", "triggerFired", "triggerMisfired", "vetoJobExecution", "", "scheduler-starter"})
public class QuartzMisfireTriggerListener
implements org.quartz.TriggerListener {
    @NotNull
    private final QuartzRegistry quartzRegistry;
    @NotNull
    private final Logger logger;

    public QuartzMisfireTriggerListener(@NotNull QuartzRegistry quartzRegistry, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)quartzRegistry, (String)"quartzRegistry");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.quartzRegistry = quartzRegistry;
        this.logger = logger;
    }

    @NotNull
    public String getName() {
        String string = QuartzMisfireTriggerListener.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return string;
    }

    public void triggerFired(@Nullable Trigger trigger, @Nullable JobExecutionContext context) {
    }

    public boolean vetoJobExecution(@Nullable Trigger trigger, @Nullable JobExecutionContext context) {
        return false;
    }

    public void triggerMisfired(@Nullable Trigger trigger) {
        block0: {
            Trigger trigger2 = trigger;
            if (trigger2 == null) break block0;
            Trigger it = trigger2;
            boolean bl = false;
            this.logger.info("Trigger misfired with trigger name: " + it.getKey() + " and expected fire time: " + it.getNextFireTime());
            long l = it.getNextFireTime().getTime();
            long l2 = Instant.now().toEpochMilli();
            TriggerKey triggerKey = it.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)triggerKey, (String)"getKey(...)");
            this.quartzRegistry.exposeMisfireMetrics(l, l2, triggerKey);
        }
    }

    public void triggerComplete(@Nullable Trigger trigger, @Nullable JobExecutionContext context, @Nullable Trigger.CompletedExecutionInstruction triggerInstructionCode) {
    }
}

