/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.quartz.metric.registry;

import box.tapsi.libs.metrics.core.MeterName;
import box.tapsi.libs.metrics.core.services.MeterRegistryService;
import io.micrometer.core.instrument.Tag;
import io.micrometer.observation.ObservationRegistry;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import reactor.core.observability.micrometer.Micrometer;
import reactor.core.publisher.Mono;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J*\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lbox/tapsi/libs/scheduler/quartz/metric/registry/QuartzRegistry;", "", "logger", "Lorg/slf4j/Logger;", "meterRegistryService", "Lbox/tapsi/libs/metrics/core/services/MeterRegistryService;", "observationRegistry", "Lio/micrometer/observation/ObservationRegistry;", "(Lorg/slf4j/Logger;Lbox/tapsi/libs/metrics/core/services/MeterRegistryService;Lio/micrometer/observation/ObservationRegistry;)V", "exposeExecutionMetrics", "Lreactor/core/publisher/Mono;", "T", "publisher", "jobDetail", "Lorg/quartz/JobDetail;", "exposeMisfireMetrics", "", "expectedFireTime", "", "actualFireTime", "triggerKey", "Lorg/quartz/TriggerKey;", "exposeSchedulingMetrics", "incrementActiveJob", "ctx", "Lorg/quartz/JobExecutionContext;", "incrementPendingJob", "Companion", "scheduler-starter"})
public class QuartzRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final MeterRegistryService meterRegistryService;
    @NotNull
    private final ObservationRegistry observationRegistry;
    @NotNull
    public static final String QUARTZ_TRIGGER_GROUP_METRICS_NAME = "triggerGroup";
    @NotNull
    public static final String QUARTZ_TRIGGER_NAME_METRICS_NAME = "triggerName";
    @NotNull
    public static final String QUARTZ_JOB_GROUP_METRICS_NAME = "jobGroup";
    @NotNull
    public static final String QUARTZ_JOB_NAME_METRICS_NAME = "jobName";
    @NotNull
    public static final String QUARTZ_SCHEDULING_METRICS_NAME = "quartz.metrics.scheduling";
    @NotNull
    public static final String QUARTZ_EXECUTION_METRICS_NAME = "quartz.metrics.execution";

    public QuartzRegistry(@NotNull Logger logger, @NotNull MeterRegistryService meterRegistryService, @NotNull ObservationRegistry observationRegistry) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)meterRegistryService, (String)"meterRegistryService");
        Intrinsics.checkNotNullParameter((Object)observationRegistry, (String)"observationRegistry");
        this.logger = logger;
        this.meterRegistryService = meterRegistryService;
        this.observationRegistry = observationRegistry;
    }

    public void incrementPendingJob(@NotNull TriggerKey triggerKey) {
        Intrinsics.checkNotNullParameter((Object)triggerKey, (String)"triggerKey");
        Object[] objectArray = new Tag[]{Tag.of((String)QUARTZ_TRIGGER_GROUP_METRICS_NAME, (String)triggerKey.getGroup()), Tag.of((String)QUARTZ_TRIGGER_NAME_METRICS_NAME, (String)triggerKey.getName())};
        this.meterRegistryService.incrementCounter((MeterName)Companion.MeterName.QuartzPendingExecutionJobCount, CollectionsKt.listOf((Object[])objectArray));
        this.logger.info("Incremented pending job count for triggerKey: " + triggerKey);
    }

    public void exposeMisfireMetrics(long expectedFireTime, long actualFireTime, @NotNull TriggerKey triggerKey) {
        Intrinsics.checkNotNullParameter((Object)triggerKey, (String)"triggerKey");
        long misfireTime = actualFireTime - expectedFireTime;
        Object[] objectArray = new Tag[]{Tag.of((String)QUARTZ_TRIGGER_GROUP_METRICS_NAME, (String)triggerKey.getGroup()), Tag.of((String)QUARTZ_TRIGGER_NAME_METRICS_NAME, (String)triggerKey.getName())};
        this.meterRegistryService.recordTimer((MeterName)Companion.MeterName.QuartzMisfireTime, misfireTime, CollectionsKt.listOf((Object[])objectArray));
        this.logger.info("Misfire time for triggerKey: " + triggerKey + " is " + misfireTime);
    }

    public void incrementActiveJob(@NotNull JobExecutionContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object[] objectArray = new Tag[]{Tag.of((String)QUARTZ_JOB_GROUP_METRICS_NAME, (String)ctx.getJobDetail().getKey().getGroup()), Tag.of((String)QUARTZ_JOB_NAME_METRICS_NAME, (String)ctx.getJobDetail().getKey().getName())};
        this.meterRegistryService.incrementCounter((MeterName)Companion.MeterName.QuartzActiveExecutionJobCount, CollectionsKt.listOf((Object[])objectArray));
        this.logger.info("Incremented active job count for jobKey: " + ctx.getJobDetail().getKey());
    }

    @NotNull
    public <T> Mono<T> exposeSchedulingMetrics(@NotNull Mono<T> publisher, @NotNull JobDetail jobDetail) {
        Intrinsics.checkNotNullParameter(publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)jobDetail, (String)"jobDetail");
        Mono mono = publisher.name(QUARTZ_SCHEDULING_METRICS_NAME).tag(QUARTZ_JOB_GROUP_METRICS_NAME, jobDetail.getKey().getGroup()).tag(QUARTZ_JOB_NAME_METRICS_NAME, jobDetail.getKey().getName()).contextCapture().tap(Micrometer.observation((ObservationRegistry)this.observationRegistry));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"tap(...)");
        return mono;
    }

    @NotNull
    public <T> Mono<T> exposeExecutionMetrics(@NotNull Mono<T> publisher, @NotNull JobDetail jobDetail) {
        Intrinsics.checkNotNullParameter(publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)jobDetail, (String)"jobDetail");
        Mono mono = publisher.name(QUARTZ_EXECUTION_METRICS_NAME).tag(QUARTZ_JOB_GROUP_METRICS_NAME, jobDetail.getKey().getGroup()).tag(QUARTZ_JOB_NAME_METRICS_NAME, jobDetail.getKey().getName()).contextCapture().tap(Micrometer.observation((ObservationRegistry)this.observationRegistry));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"tap(...)");
        return mono;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lbox/tapsi/libs/scheduler/quartz/metric/registry/QuartzRegistry$Companion;", "", "()V", "QUARTZ_EXECUTION_METRICS_NAME", "", "QUARTZ_JOB_GROUP_METRICS_NAME", "QUARTZ_JOB_NAME_METRICS_NAME", "QUARTZ_SCHEDULING_METRICS_NAME", "QUARTZ_TRIGGER_GROUP_METRICS_NAME", "QUARTZ_TRIGGER_NAME_METRICS_NAME", "MeterName", "scheduler-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lbox/tapsi/libs/scheduler/quartz/metric/registry/QuartzRegistry$Companion$MeterName;", "", "Lbox/tapsi/libs/metrics/core/MeterName;", "meterName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getMeterName", "()Ljava/lang/String;", "QuartzActiveExecutionJobCount", "QuartzPendingExecutionJobCount", "QuartzMisfireTime", "scheduler-starter"})
        public static final class MeterName
        extends Enum<MeterName>
        implements box.tapsi.libs.metrics.core.MeterName {
            @NotNull
            private final String meterName;
            public static final /* enum */ MeterName QuartzActiveExecutionJobCount = new MeterName("quartz.metrics.execution.active.count");
            public static final /* enum */ MeterName QuartzPendingExecutionJobCount = new MeterName("quartz.metrics.execution.pending.count");
            public static final /* enum */ MeterName QuartzMisfireTime = new MeterName("quartz.metrics.execution.misfire.time");
            private static final /* synthetic */ MeterName[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private MeterName(String meterName) {
                this.meterName = meterName;
            }

            @NotNull
            public String getMeterName() {
                return this.meterName;
            }

            public static MeterName[] values() {
                return (MeterName[])$VALUES.clone();
            }

            public static MeterName valueOf(String value) {
                return Enum.valueOf(MeterName.class, value);
            }

            @NotNull
            public static EnumEntries<MeterName> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = meterNameArray = new MeterName[]{MeterName.QuartzActiveExecutionJobCount, MeterName.QuartzPendingExecutionJobCount, MeterName.QuartzMisfireTime};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }
}

