/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.quartz.services;

import box.tapsi.libs.scheduler.quartz.annotations.OnQuartzEnabled;
import box.tapsi.libs.scheduler.quartz.metric.registry.QuartzRegistry;
import box.tapsi.libs.scheduler.quartz.services.QuartzService;
import box.tapsi.libs.scheduler.quartz.services.QuartzServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.TriggerListener;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.plugins.history.LoggingJobHistoryPlugin;
import org.quartz.plugins.history.LoggingTriggerHistoryPlugin;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@OnQuartzEnabled
@Primary
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J@\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0005\u001a\u00020\u0006H\u0012J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0!2\u0006\u0010\u0005\u001a\u00020\u0006H\u0012J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0!2\u0006\u0010\u0005\u001a\u00020\u0006H\u0012J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020\u0017H\u0016J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020)H\u0016J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u00100\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020)H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lbox/tapsi/libs/scheduler/quartz/services/QuartzServiceImpl;", "Lbox/tapsi/libs/scheduler/quartz/services/QuartzService;", "Lorg/springframework/beans/factory/InitializingBean;", "logger", "Lorg/slf4j/Logger;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "schedulerFactoryBean", "Lorg/springframework/scheduling/quartz/SchedulerFactoryBean;", "quartzRegistry", "Lbox/tapsi/libs/scheduler/quartz/metric/registry/QuartzRegistry;", "(Lorg/slf4j/Logger;Lorg/springframework/context/ApplicationContext;Lorg/springframework/scheduling/quartz/SchedulerFactoryBean;Lbox/tapsi/libs/scheduler/quartz/metric/registry/QuartzRegistry;)V", "afterPropertiesSet", "", "createJob", "Lorg/quartz/JobDetail;", "TJob", "Lorg/quartz/Job;", "jobClass", "Ljava/lang/Class;", "isDurable", "", "jobName", "", "jobGroup", "jobDataMap", "Lorg/quartz/JobDataMap;", "deleteJob", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "jobKey", "Lorg/quartz/JobKey;", "getJobListeners", "", "Lorg/quartz/JobListener;", "getSchedulerListeners", "Lorg/quartz/SchedulerListener;", "getTriggerListeners", "Lorg/quartz/TriggerListener;", "getTriggers", "Lreactor/core/publisher/Flux;", "Lorg/quartz/Trigger;", "triggerGroup", "rescheduleJob", "triggerKey", "Lorg/quartz/TriggerKey;", "trigger", "scheduleJob", "jobDetail", "scheduler-starter"})
@SourceDebugExtension(value={"SMAP\nQuartzServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuartzServiceImpl.kt\nbox/tapsi/libs/scheduler/quartz/services/QuartzServiceImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1855#2,2:139\n1855#2,2:141\n1855#2,2:143\n1549#2:145\n1620#2,3:146\n1549#2:149\n1620#2,3:150\n1549#2:153\n1620#2,3:154\n*S KotlinDebug\n*F\n+ 1 QuartzServiceImpl.kt\nbox/tapsi/libs/scheduler/quartz/services/QuartzServiceImpl\n*L\n96#1:139,2\n99#1:141,2\n102#1:143,2\n112#1:145\n112#1:146,3\n123#1:149\n123#1:150,3\n132#1:153\n132#1:154,3\n*E\n"})
public class QuartzServiceImpl
implements QuartzService,
InitializingBean {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final SchedulerFactoryBean schedulerFactoryBean;
    @NotNull
    private final QuartzRegistry quartzRegistry;

    public QuartzServiceImpl(@NotNull Logger logger, @NotNull ApplicationContext applicationContext, @NotNull SchedulerFactoryBean schedulerFactoryBean, @NotNull QuartzRegistry quartzRegistry) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)schedulerFactoryBean, (String)"schedulerFactoryBean");
        Intrinsics.checkNotNullParameter((Object)quartzRegistry, (String)"quartzRegistry");
        this.logger = logger;
        this.applicationContext = applicationContext;
        this.schedulerFactoryBean = schedulerFactoryBean;
        this.quartzRegistry = quartzRegistry;
    }

    @Override
    @NotNull
    public <TJob extends Job> JobDetail createJob(@NotNull Class<TJob> jobClass, boolean isDurable, @NotNull String jobName, @NotNull String jobGroup, @NotNull JobDataMap jobDataMap) {
        JobBuilder jobBuilder;
        Intrinsics.checkNotNullParameter(jobClass, (String)"jobClass");
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        Intrinsics.checkNotNullParameter((Object)jobGroup, (String)"jobGroup");
        Intrinsics.checkNotNullParameter((Object)jobDataMap, (String)"jobDataMap");
        JobBuilder $this$createJob_u24lambda_u240 = jobBuilder = JobBuilder.newJob(jobClass);
        boolean bl = false;
        jobDataMap.put(jobName + jobGroup, jobClass.getName());
        $this$createJob_u24lambda_u240.setJobData(jobDataMap);
        JobDetail jobDetail = jobBuilder.withIdentity(jobName, jobGroup).storeDurably(isDurable).requestRecovery().build();
        Intrinsics.checkNotNullExpressionValue((Object)jobDetail, (String)"build(...)");
        return jobDetail;
    }

    @Override
    @NotNull
    public Mono<Void> scheduleJob(@NotNull JobDetail jobDetail, @NotNull Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)jobDetail, (String)"jobDetail");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Mono mono = Mono.fromRunnable(() -> QuartzServiceImpl.scheduleJob$lambda$1(this, jobDetail, trigger)).transform(arg_0 -> QuartzServiceImpl.scheduleJob$lambda$2((Function1)new Function1<Mono<Void>, Publisher<Void>>(this, jobDetail){
            final /* synthetic */ QuartzServiceImpl this$0;
            final /* synthetic */ JobDetail $jobDetail;
            {
                this.this$0 = $receiver;
                this.$jobDetail = $jobDetail;
                super(1);
            }

            public final Publisher<Void> invoke(Mono<Void> it) {
                QuartzRegistry quartzRegistry = QuartzServiceImpl.access$getQuartzRegistry$p(this.this$0);
                Intrinsics.checkNotNull(it);
                return (Publisher)quartzRegistry.exposeSchedulingMetrics(it, this.$jobDetail);
            }
        }, arg_0)).doOnSuccess(arg_0 -> QuartzServiceImpl.scheduleJob$lambda$3((Function1)new Function1<Void, Unit>(this, jobDetail, trigger){
            final /* synthetic */ QuartzServiceImpl this$0;
            final /* synthetic */ JobDetail $jobDetail;
            final /* synthetic */ Trigger $trigger;
            {
                this.this$0 = $receiver;
                this.$jobDetail = $jobDetail;
                this.$trigger = $trigger;
                super(1);
            }

            public final void invoke(Void it) {
                QuartzServiceImpl.access$getLogger$p(this.this$0).info("Job scheduled successfully with job name: " + this.$jobDetail.getKey() + " and trigger: " + this.$trigger.getNextFireTime());
            }
        }, arg_0)).doOnError(arg_0 -> QuartzServiceImpl.scheduleJob$lambda$4((Function1)new Function1<Throwable, Unit>(this, jobDetail, trigger){
            final /* synthetic */ QuartzServiceImpl this$0;
            final /* synthetic */ JobDetail $jobDetail;
            final /* synthetic */ Trigger $trigger;
            {
                this.this$0 = $receiver;
                this.$jobDetail = $jobDetail;
                this.$trigger = $trigger;
                super(1);
            }

            public final void invoke(Throwable it) {
                QuartzServiceImpl.access$getLogger$p(this.this$0).error("Error in job scheduling with job name: " + this.$jobDetail.getKey() + " and trigger: " + this.$trigger.getNextFireTime(), it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnError(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> deleteJob(@NotNull JobKey jobKey) {
        Intrinsics.checkNotNullParameter((Object)jobKey, (String)"jobKey");
        Mono mono = Mono.fromRunnable(() -> QuartzServiceImpl.deleteJob$lambda$5(this, jobKey)).doOnSuccess(arg_0 -> QuartzServiceImpl.deleteJob$lambda$6((Function1)new Function1<Void, Unit>(this, jobKey){
            final /* synthetic */ QuartzServiceImpl this$0;
            final /* synthetic */ JobKey $jobKey;
            {
                this.this$0 = $receiver;
                this.$jobKey = $jobKey;
                super(1);
            }

            public final void invoke(Void it) {
                QuartzServiceImpl.access$getLogger$p(this.this$0).info("Job deleted successfully with job name: " + this.$jobKey.getName() + " and group: " + this.$jobKey.getGroup());
            }
        }, arg_0)).doOnError(arg_0 -> QuartzServiceImpl.deleteJob$lambda$7((Function1)new Function1<Throwable, Unit>(this, jobKey){
            final /* synthetic */ QuartzServiceImpl this$0;
            final /* synthetic */ JobKey $jobKey;
            {
                this.this$0 = $receiver;
                this.$jobKey = $jobKey;
                super(1);
            }

            public final void invoke(Throwable it) {
                QuartzServiceImpl.access$getLogger$p(this.this$0).error("Error in a job deletion with job name: " + this.$jobKey.getName() + " and group: " + this.$jobKey.getGroup(), it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnError(...)");
        return mono;
    }

    @Override
    @NotNull
    public Flux<Trigger> getTriggers(@NotNull String triggerGroup) {
        Intrinsics.checkNotNullParameter((Object)triggerGroup, (String)"triggerGroup");
        Flux flux = Mono.fromCallable(() -> QuartzServiceImpl.getTriggers$lambda$8(this, triggerGroup)).flatMapIterable(arg_0 -> QuartzServiceImpl.getTriggers$lambda$9(getTriggers.2.INSTANCE, arg_0)).flatMap(arg_0 -> QuartzServiceImpl.getTriggers$lambda$10((Function1)new Function1<TriggerKey, Publisher<? extends Trigger>>(this){
            final /* synthetic */ QuartzServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Publisher<? extends Trigger> invoke(TriggerKey it) {
                return (Publisher)Mono.fromCallable(() -> getTriggers.3.invoke$lambda$0(this.this$0, it));
            }

            private static final Trigger invoke$lambda$0(QuartzServiceImpl this$0, TriggerKey $it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                return QuartzServiceImpl.access$getSchedulerFactoryBean$p(this$0).getScheduler().getTrigger($it);
            }
        }, arg_0)).doOnNext(arg_0 -> QuartzServiceImpl.getTriggers$lambda$11((Function1)new Function1<Trigger, Unit>(this){
            final /* synthetic */ QuartzServiceImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Trigger it) {
                QuartzServiceImpl.access$getLogger$p(this.this$0).info("Trigger found with trigger name: " + it.getKey().getName() + " and group: " + it.getKey().getGroup());
            }
        }, arg_0)).doOnError(arg_0 -> QuartzServiceImpl.getTriggers$lambda$12((Function1)new Function1<Throwable, Unit>(this, triggerGroup){
            final /* synthetic */ QuartzServiceImpl this$0;
            final /* synthetic */ String $triggerGroup;
            {
                this.this$0 = $receiver;
                this.$triggerGroup = $triggerGroup;
                super(1);
            }

            public final void invoke(Throwable it) {
                QuartzServiceImpl.access$getLogger$p(this.this$0).error("Error in finding triggers in group " + this.$triggerGroup, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"doOnError(...)");
        return flux;
    }

    @Override
    @NotNull
    public Mono<Void> rescheduleJob(@NotNull TriggerKey triggerKey, @NotNull Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)triggerKey, (String)"triggerKey");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Mono mono = Mono.fromCallable(() -> QuartzServiceImpl.rescheduleJob$lambda$13(this, triggerKey, trigger)).doOnNext(arg_0 -> QuartzServiceImpl.rescheduleJob$lambda$14((Function1)new Function1<Date, Unit>(this, triggerKey){
            final /* synthetic */ QuartzServiceImpl this$0;
            final /* synthetic */ TriggerKey $triggerKey;
            {
                this.this$0 = $receiver;
                this.$triggerKey = $triggerKey;
                super(1);
            }

            public final void invoke(Date it) {
                QuartzServiceImpl.access$getLogger$p(this.this$0).info("Job rescheduled successfully with trigger: " + this.$triggerKey + " and next fire time: " + it);
            }
        }, arg_0)).doOnError(arg_0 -> QuartzServiceImpl.rescheduleJob$lambda$15((Function1)new Function1<Throwable, Unit>(this, triggerKey){
            final /* synthetic */ QuartzServiceImpl this$0;
            final /* synthetic */ TriggerKey $triggerKey;
            {
                this.this$0 = $receiver;
                this.$triggerKey = $triggerKey;
                super(1);
            }

            public final void invoke(Throwable it) {
                QuartzServiceImpl.access$getLogger$p(this.this$0).error("Error in a job rescheduling with trigger: " + this.$triggerKey, it);
            }
        }, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        return mono;
    }

    public void afterPropertiesSet() {
        JobListener it;
        Iterable $this$forEach$iv = this.getJobListeners(this.applicationContext);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (JobListener)element$iv;
            boolean bl = false;
            this.schedulerFactoryBean.getScheduler().getListenerManager().addJobListener(it);
        }
        $this$forEach$iv = this.getSchedulerListeners(this.applicationContext);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SchedulerListener)element$iv;
            boolean bl = false;
            this.schedulerFactoryBean.getScheduler().getListenerManager().addSchedulerListener((SchedulerListener)it);
        }
        $this$forEach$iv = this.getTriggerListeners(this.applicationContext);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TriggerListener)element$iv;
            boolean bl = false;
            this.schedulerFactoryBean.getScheduler().getListenerManager().addTriggerListener((TriggerListener)it);
        }
        new LoggingJobHistoryPlugin().initialize("LoggingJobHistoryPlugin", this.schedulerFactoryBean.getScheduler(), null);
        new LoggingTriggerHistoryPlugin().initialize("LoggingTriggerHistoryPlugin", this.schedulerFactoryBean.getScheduler(), null);
    }

    /*
     * WARNING - void declaration
     */
    private List<JobListener> getJobListeners(ApplicationContext applicationContext) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = applicationContext.getBeansWithAnnotation(box.tapsi.libs.scheduler.quartz.annotations.JobListener.class).values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            JobListener jobListener;
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.quartz.JobListener");
            JobListener jobListener2 = jobListener = (JobListener)it;
            boolean bl2 = false;
            this.logger.info("Found job listener: " + jobListener2.getName());
            collection.add(jobListener);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<SchedulerListener> getSchedulerListeners(ApplicationContext applicationContext) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = applicationContext.getBeansWithAnnotation(box.tapsi.libs.scheduler.quartz.annotations.SchedulerListener.class).values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            SchedulerListener schedulerListener;
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.quartz.SchedulerListener");
            SchedulerListener schedulerListener2 = schedulerListener = (SchedulerListener)it;
            boolean bl2 = false;
            this.logger.info("Found scheduler listener: " + Reflection.getOrCreateKotlinClass(schedulerListener2.getClass()).getSimpleName());
            collection.add(schedulerListener);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<TriggerListener> getTriggerListeners(ApplicationContext applicationContext) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = applicationContext.getBeansWithAnnotation(box.tapsi.libs.scheduler.quartz.annotations.TriggerListener.class).values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            TriggerListener triggerListener;
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.quartz.TriggerListener");
            TriggerListener triggerListener2 = triggerListener = (TriggerListener)it;
            boolean bl2 = false;
            this.logger.info("Found trigger listener: " + triggerListener2.getName());
            collection.add(triggerListener);
        }
        return (List)destination$iv$iv;
    }

    private static final void scheduleJob$lambda$1(QuartzServiceImpl this$0, JobDetail $jobDetail, Trigger $trigger) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$jobDetail, (String)"$jobDetail");
        Intrinsics.checkNotNullParameter((Object)$trigger, (String)"$trigger");
        this$0.schedulerFactoryBean.getScheduler().scheduleJob($jobDetail, $trigger);
    }

    private static final Publisher scheduleJob$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void scheduleJob$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void scheduleJob$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void deleteJob$lambda$5(QuartzServiceImpl this$0, JobKey $jobKey) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$jobKey, (String)"$jobKey");
        this$0.schedulerFactoryBean.getScheduler().deleteJob($jobKey);
    }

    private static final void deleteJob$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void deleteJob$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Set getTriggers$lambda$8(QuartzServiceImpl this$0, String $triggerGroup) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$triggerGroup, (String)"$triggerGroup");
        return this$0.schedulerFactoryBean.getScheduler().getTriggerKeys(GroupMatcher.groupEquals((String)$triggerGroup));
    }

    private static final Iterable getTriggers$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final Publisher getTriggers$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void getTriggers$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void getTriggers$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Date rescheduleJob$lambda$13(QuartzServiceImpl this$0, TriggerKey $triggerKey, Trigger $trigger) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$triggerKey, (String)"$triggerKey");
        Intrinsics.checkNotNullParameter((Object)$trigger, (String)"$trigger");
        return this$0.schedulerFactoryBean.getScheduler().rescheduleJob($triggerKey, $trigger);
    }

    private static final void rescheduleJob$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void rescheduleJob$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ QuartzRegistry access$getQuartzRegistry$p(QuartzServiceImpl $this) {
        return $this.quartzRegistry;
    }

    public static final /* synthetic */ Logger access$getLogger$p(QuartzServiceImpl $this) {
        return $this.logger;
    }

    public static final /* synthetic */ SchedulerFactoryBean access$getSchedulerFactoryBean$p(QuartzServiceImpl $this) {
        return $this.schedulerFactoryBean;
    }
}

