/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.scheduler.aop.interceptors;

import box.tapsi.libs.scheduler.scheduler.SchedulerException;
import box.tapsi.libs.scheduler.scheduler.schedulers.DefaultScheduler;
import box.tapsi.libs.scheduler.scheduler.store.JobStore;
import box.tapsi.libs.utilities.time.TimeOperator;
import io.github.mahdibohloul.projectreactor.retry.aop.annotation.ReactiveRetryable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component(value="retryJobInterceptor")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 <2\u00020\u0001:\u0001<B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JI\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u0014\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\u000e2\u0014\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b0\u000eH\u0012\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J/\u0010\u001d\u001a\u0004\u0018\u0001H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001e0#H\u0012\u00a2\u0006\u0002\u0010$J7\u0010%\u001a\u0004\u0018\u0001H\u001e\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u0010&\u001a\u00020'2\u0006\u0010 \u001a\u00020!2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u001e0#H\u0012\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020+H\u0012J(\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\"\b\b\u0000\u0010-*\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\u0013\u00101\u001a\u0004\u0018\u00010'2\u0006\u0010/\u001a\u000200H\u0096\u0002J\u001e\u00102\u001a\u00020\t\"\b\b\u0000\u0010-*\u00020'2\n\u00103\u001a\u0006\u0012\u0002\b\u00030#H\u0012J\u0010\u00104\u001a\u00020\t2\u0006\u00105\u001a\u00020\u0019H\u0012J\u0018\u00106\u001a\u0002072\u0006\u0010/\u001a\u0002002\u0006\u0010\u001b\u001a\u00020\u001cH\u0012JE\u00108\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\"\b\b\u0000\u0010-*\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00109\u001a\u0002H-H\u0012\u00a2\u0006\u0002\u0010:J\u0018\u0010;\u001a\u0002072\u0006\u0010/\u001a\u0002002\u0006\u0010\u001b\u001a\u00020\u001cH\u0012R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lbox/tapsi/libs/scheduler/scheduler/aop/interceptors/RetryJobInterceptor;", "Lorg/aopalliance/intercept/MethodInterceptor;", "timeOperator", "Lbox/tapsi/libs/utilities/time/TimeOperator;", "(Lbox/tapsi/libs/utilities/time/TimeOperator;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "canRetry", "", "err", "Lkotlin/reflect/KClass;", "", "include", "", "exclude", "(Lkotlin/reflect/KClass;[Lkotlin/reflect/KClass;[Lkotlin/reflect/KClass;)Z", "checkExhaustedRetry", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "retryCount", "", "reactiveRetryable", "Lio/github/mahdibohloul/projectreactor/retry/aop/annotation/ReactiveRetryable;", "jobName", "", "checkRetryAttemptsLimit", "jobStore", "Lbox/tapsi/libs/scheduler/scheduler/store/JobStore;", "classLevelAnnotation", "T", "", "method", "Ljava/lang/reflect/Method;", "annotationClass", "Ljava/lang/Class;", "(Ljava/lang/reflect/Method;Ljava/lang/Class;)Ljava/lang/annotation/Annotation;", "findAnnotationOnTarget", "target", "", "annotation", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/Class;)Ljava/lang/annotation/Annotation;", "getNextFireTime", "Ljava/time/Instant;", "handleJob", "TJob", "Lbox/tapsi/libs/scheduler/scheduler/schedulers/DefaultScheduler;", "invocation", "Lorg/aopalliance/intercept/MethodInvocation;", "invoke", "isJobClass", "declaringClass", "isSchedulerExecuteMethod", "methodName", "putRetryCountIfNecessary", "", "retryJob", "scheduler", "(Lorg/aopalliance/intercept/MethodInvocation;ILbox/tapsi/libs/scheduler/scheduler/store/JobStore;Lio/github/mahdibohloul/projectreactor/retry/aop/annotation/ReactiveRetryable;Lbox/tapsi/libs/scheduler/scheduler/schedulers/DefaultScheduler;)Lreactor/core/publisher/Mono;", "updateJobStore", "Companion", "scheduler-starter"})
@SourceDebugExtension(value={"SMAP\nRetryJobInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RetryJobInterceptor.kt\nbox/tapsi/libs/scheduler/scheduler/aop/interceptors/RetryJobInterceptor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,163:1\n12474#2,2:164\n12474#2,2:166\n*S KotlinDebug\n*F\n+ 1 RetryJobInterceptor.kt\nbox/tapsi/libs/scheduler/scheduler/aop/interceptors/RetryJobInterceptor\n*L\n70#1:164,2\n75#1:166,2\n*E\n"})
public class RetryJobInterceptor
implements MethodInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TimeOperator timeOperator;
    private final Logger logger;
    @NotNull
    public static final String RETRY_COUNT_JOB_STORE_KEY = "retryCount";
    public static final long FIXED_OFFSET_RETRY_MILLIS = 60000L;
    @NotNull
    public static final String RETRY_JOB_INTERCEPTOR_NAME = "retryJobInterceptor";
    public static final int JOB_STORE_INDEX = 0;

    public RetryJobInterceptor(@NotNull TimeOperator timeOperator) {
        Intrinsics.checkNotNullParameter((Object)timeOperator, (String)"timeOperator");
        this.timeOperator = timeOperator;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Nullable
    public Object invoke(@NotNull MethodInvocation invocation) {
        Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
        String methodName = invocation.getMethod().getName();
        Intrinsics.checkNotNull((Object)methodName);
        if (!this.isSchedulerExecuteMethod(methodName)) {
            return invocation.proceed();
        }
        ReactiveRetryable reactiveRetryable = (ReactiveRetryable)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)invocation.getMethod(), ReactiveRetryable.class);
        if (reactiveRetryable == null) {
            Method method = invocation.getMethod();
            Intrinsics.checkNotNullExpressionValue((Object)method, (String)"getMethod(...)");
            reactiveRetryable = this.classLevelAnnotation(method, ReactiveRetryable.class);
            if (reactiveRetryable == null) {
                Object object = invocation.getThis();
                Intrinsics.checkNotNull((Object)object);
                Method method2 = invocation.getMethod();
                Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"getMethod(...)");
                reactiveRetryable = this.findAnnotationOnTarget(object, method2, ReactiveRetryable.class);
            }
        }
        ReactiveRetryable reactiveRetryable2 = reactiveRetryable;
        Class<?> clazz = invocation.getMethod().getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getDeclaringClass(...)");
        return this.isJobClass(clazz) && reactiveRetryable2 != null ? this.handleJob(invocation, reactiveRetryable2) : invocation.proceed();
    }

    private <T extends Annotation> T classLevelAnnotation(Method method, Class<T> annotationClass) {
        return (T)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method.getDeclaringClass(), annotationClass);
    }

    private Instant getNextFireTime() {
        return this.timeOperator.addToCurrentTime(60000L, TimeUnit.MILLISECONDS);
    }

    private <T extends Annotation> T findAnnotationOnTarget(Object target, Method method, Class<T> annotation) {
        Annotation annotation2;
        try {
            Class<?>[] classArray = method.getParameterTypes();
            Method targetMethod = target.getClass().getMethod(method.getName(), Arrays.copyOf(classArray, classArray.length));
            Annotation annotation3 = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)targetMethod, annotation);
            if (annotation3 == null) {
                Intrinsics.checkNotNull((Object)targetMethod);
                annotation3 = this.classLevelAnnotation(targetMethod, annotation);
            }
            annotation2 = annotation3;
        }
        catch (Exception exception) {
            this.logger.error("Error finding annotation on target", (Throwable)exception);
            annotation2 = null;
        }
        return (T)annotation2;
    }

    private boolean canRetry(KClass<? extends Throwable> err, KClass<? extends Throwable>[] include, KClass<? extends Throwable>[] exclude) {
        boolean bl;
        block7: {
            boolean bl2;
            KClass<? extends Throwable> ex;
            KClass<? extends Throwable> element$iv;
            int n;
            int n2;
            boolean $i$f$any;
            KClass<? extends Throwable>[] $this$any$iv;
            block6: {
                $this$any$iv = exclude;
                $i$f$any = false;
                n2 = $this$any$iv.length;
                for (n = 0; n < n2; ++n) {
                    ex = element$iv = $this$any$iv[n];
                    boolean bl3 = false;
                    if (!KClasses.isSuperclassOf(ex, err)) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
            if (bl2) {
                bl = false;
            } else if (include.length == 0) {
                bl = true;
            } else {
                $this$any$iv = include;
                $i$f$any = false;
                n2 = $this$any$iv.length;
                for (n = 0; n < n2; ++n) {
                    ex = element$iv = $this$any$iv[n];
                    boolean bl4 = false;
                    if (!KClasses.isSuperclassOf(ex, err)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private boolean isSchedulerExecuteMethod(String methodName) {
        return Intrinsics.areEqual((Object)methodName, (Object)"execute") || Intrinsics.areEqual((Object)methodName, (Object)"execute");
    }

    private <TJob> boolean isJobClass(Class<?> declaringClass) {
        return (declaringClass instanceof Class ? declaringClass : null) != null;
    }

    private <TJob extends DefaultScheduler> Mono<Void> handleJob(MethodInvocation invocation, ReactiveRetryable reactiveRetryable) {
        Object object;
        Object object2 = invocation.getThis();
        DefaultScheduler defaultScheduler = object2 instanceof DefaultScheduler ? (DefaultScheduler)object2 : null;
        if (defaultScheduler == null) {
            Object object3 = invocation.proceed();
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type reactor.core.publisher.Mono<java.lang.Void>");
            return (Mono)object3;
        }
        DefaultScheduler scheduler = defaultScheduler;
        Object object4 = invocation.getArguments()[0];
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type box.tapsi.libs.scheduler.scheduler.store.JobStore");
        JobStore jobStore = (JobStore)object4;
        this.putRetryCountIfNecessary(invocation, jobStore);
        if (this.checkRetryAttemptsLimit(jobStore, reactiveRetryable)) {
            Object object5 = invocation.proceed();
            Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type reactor.core.publisher.Mono<java.lang.Void>");
            object = (Mono)object5;
        } else {
            Object object6 = invocation.proceed();
            Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type reactor.core.publisher.Mono<java.lang.Void>");
            object2 = ((Mono)object6).onErrorResume(arg_0 -> RetryJobInterceptor.handleJob$lambda$2((Function1)new Function1<Throwable, Mono<? extends Void>>(this, scheduler, reactiveRetryable, jobStore, invocation){
                final /* synthetic */ RetryJobInterceptor this$0;
                final /* synthetic */ TJob $scheduler;
                final /* synthetic */ ReactiveRetryable $reactiveRetryable;
                final /* synthetic */ JobStore $jobStore;
                final /* synthetic */ MethodInvocation $invocation;
                {
                    this.this$0 = $receiver;
                    this.$scheduler = $scheduler;
                    this.$reactiveRetryable = $reactiveRetryable;
                    this.$jobStore = $jobStore;
                    this.$invocation = $invocation;
                    super(1);
                }

                public final Mono<? extends Void> invoke(Throwable it) {
                    RetryJobInterceptor.access$getLogger$p(this.this$0).error("Error while executing job " + Reflection.getOrCreateKotlinClass(this.$scheduler.getClass()).getSimpleName(), it);
                    if (RetryJobInterceptor.access$canRetry(this.this$0, Reflection.getOrCreateKotlinClass(it.getClass()), Reflection.getOrCreateKotlinClasses((Class[])this.$reactiveRetryable.include()), Reflection.getOrCreateKotlinClasses((Class[])this.$reactiveRetryable.exclude()))) {
                        RetryJobInterceptor.access$getLogger$p(this.this$0).info("Job " + Reflection.getOrCreateKotlinClass(this.$scheduler.getClass()).getSimpleName() + " included in retry on " + Reflection.getOrCreateKotlinClass(it.getClass()));
                        Integer n = this.$jobStore.getInt("retryCount");
                        Intrinsics.checkNotNull((Object)n);
                        int retryCount = n;
                        this.$jobStore.put("retryCount", retryCount + 1);
                        return RetryJobInterceptor.access$retryJob(this.this$0, this.$invocation, retryCount, this.$jobStore, this.$reactiveRetryable, this.$scheduler).then(Mono.error((Throwable)it));
                    }
                    RetryJobInterceptor.access$getLogger$p(this.this$0).info("Job " + this.$invocation.getMethod().getName() + " excluded from retry on " + Reflection.getOrCreateKotlinClass(it.getClass()));
                    return Mono.error((Throwable)it);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)object2);
            object = object2;
        }
        return object;
    }

    private void putRetryCountIfNecessary(MethodInvocation invocation, JobStore jobStore) {
        if (!jobStore.contains(RETRY_COUNT_JOB_STORE_KEY)) {
            jobStore.put(RETRY_COUNT_JOB_STORE_KEY, 0);
            this.updateJobStore(invocation, jobStore);
        }
    }

    private void updateJobStore(MethodInvocation invocation, JobStore jobStore) {
        invocation.getArguments()[0] = jobStore;
    }

    private boolean checkRetryAttemptsLimit(JobStore jobStore, ReactiveRetryable reactiveRetryable) {
        Integer n = jobStore.getInt(RETRY_COUNT_JOB_STORE_KEY);
        Intrinsics.checkNotNull((Object)n);
        int retryCount = n;
        return (long)retryCount > reactiveRetryable.maxAttempts();
    }

    private <TJob extends DefaultScheduler> Mono<Void> retryJob(MethodInvocation invocation, int retryCount, JobStore jobStore, ReactiveRetryable reactiveRetryable, TJob scheduler) {
        String string = invocation.getMethod().getDeclaringClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        Mono mono = this.checkExhaustedRetry(retryCount, reactiveRetryable, string).thenReturn((Object)this.getNextFireTime()).doOnNext(arg_0 -> RetryJobInterceptor.retryJob$lambda$3((Function1)new Function1<Instant, Unit>(this, invocation){
            final /* synthetic */ RetryJobInterceptor this$0;
            final /* synthetic */ MethodInvocation $invocation;
            {
                this.this$0 = $receiver;
                this.$invocation = $invocation;
                super(1);
            }

            public final void invoke(Instant it) {
                RetryJobInterceptor.access$getLogger$p(this.this$0).info("Job " + this.$invocation.getMethod().getDeclaringClass().getSimpleName() + " will be retried at " + it + " later");
            }
        }, arg_0)).flatMap(arg_0 -> RetryJobInterceptor.retryJob$lambda$4((Function1)new Function1<Instant, Mono<? extends Void>>(scheduler, jobStore){
            final /* synthetic */ TJob $scheduler;
            final /* synthetic */ JobStore $jobStore;
            {
                this.$scheduler = $scheduler;
                this.$jobStore = $jobStore;
                super(1);
            }

            public final Mono<? extends Void> invoke(Instant fireTimestamp) {
                return this.$scheduler.schedule(this.$jobStore, fireTimestamp);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    private Mono<Void> checkExhaustedRetry(int retryCount, ReactiveRetryable reactiveRetryable, String jobName) {
        if ((long)(retryCount + 1) > reactiveRetryable.maxAttempts()) {
            this.logger.error("Retry exhausted for job " + jobName + " with " + retryCount + " attempts");
            Mono mono = Mono.error((Throwable)((Throwable)((Object)new SchedulerException.ExhaustedJobRetryException("Retry exhausted for job " + jobName + " with " + retryCount + " attempts"))));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        Mono mono = Mono.empty();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty(...)");
        return mono;
    }

    private static final Mono handleJob$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void retryJob$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Mono retryJob$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(RetryJobInterceptor $this) {
        return $this.logger;
    }

    public static final /* synthetic */ boolean access$canRetry(RetryJobInterceptor $this, KClass err, KClass[] include, KClass[] exclude) {
        return $this.canRetry((KClass<? extends Throwable>)err, include, exclude);
    }

    public static final /* synthetic */ Mono access$retryJob(RetryJobInterceptor $this, MethodInvocation invocation, int retryCount, JobStore jobStore, ReactiveRetryable reactiveRetryable, DefaultScheduler scheduler) {
        return $this.retryJob(invocation, retryCount, jobStore, reactiveRetryable, scheduler);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/aop/interceptors/RetryJobInterceptor$Companion;", "", "()V", "FIXED_OFFSET_RETRY_MILLIS", "", "JOB_STORE_INDEX", "", "RETRY_COUNT_JOB_STORE_KEY", "", "RETRY_JOB_INTERCEPTOR_NAME", "scheduler-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

