/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.scheduler.mappers;

import box.tapsi.libs.scheduler.scheduler.JobGroup;
import box.tapsi.libs.scheduler.scheduler.SchedulingExtensionsKt;
import box.tapsi.libs.scheduler.scheduler.SchedulingInstruction;
import box.tapsi.libs.scheduler.scheduler.Trigger;
import box.tapsi.libs.scheduler.scheduler.TriggerGroup;
import box.tapsi.libs.utilities.time.TimeOperator;
import java.time.Instant;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/mappers/SchedulingInstructionMapper;", "", "()V", "toModel", "Lbox/tapsi/libs/scheduler/scheduler/Trigger;", "instruction", "Lbox/tapsi/libs/scheduler/scheduler/SchedulingInstruction;", "timeOperator", "Lbox/tapsi/libs/utilities/time/TimeOperator;", "CronMapper", "RegularMapper", "scheduler-starter"})
public final class SchedulingInstructionMapper {
    @NotNull
    public static final SchedulingInstructionMapper INSTANCE = new SchedulingInstructionMapper();

    private SchedulingInstructionMapper() {
    }

    @NotNull
    public final Trigger toModel(@NotNull SchedulingInstruction instruction, @NotNull TimeOperator timeOperator) {
        Trigger trigger;
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)timeOperator, (String)"timeOperator");
        SchedulingInstruction schedulingInstruction = instruction;
        if (schedulingInstruction instanceof SchedulingInstruction.Regular) {
            trigger = RegularMapper.INSTANCE.toModel((SchedulingInstruction.Regular)instruction);
        } else if (schedulingInstruction instanceof SchedulingInstruction.Cron) {
            trigger = CronMapper.INSTANCE.toModel((SchedulingInstruction.Cron)instruction, timeOperator);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return trigger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/mappers/SchedulingInstructionMapper$CronMapper;", "", "()V", "CRON_TRIGGER_TRIGGER_ID_FORMAT", "", "toModel", "Lbox/tapsi/libs/scheduler/scheduler/Trigger$CronTrigger;", "instruction", "Lbox/tapsi/libs/scheduler/scheduler/SchedulingInstruction$Cron;", "timeOperator", "Lbox/tapsi/libs/utilities/time/TimeOperator;", "scheduler-starter"})
    private static final class CronMapper {
        @NotNull
        public static final CronMapper INSTANCE = new CronMapper();
        @NotNull
        private static final String CRON_TRIGGER_TRIGGER_ID_FORMAT = "%s_cron_trigger";

        private CronMapper() {
        }

        @NotNull
        public final Trigger.CronTrigger toModel(@NotNull SchedulingInstruction.Cron instruction, @NotNull TimeOperator timeOperator) {
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            Intrinsics.checkNotNullParameter((Object)timeOperator, (String)"timeOperator");
            JobGroup jobGroup = instruction.getJobGroup();
            String string = SchedulingExtensionsKt.getCompositeJobId(instruction);
            TriggerGroup triggerGroup = instruction.getTriggerGroup();
            String string2 = CRON_TRIGGER_TRIGGER_ID_FORMAT;
            Object[] objectArray = new Object[]{SchedulingExtensionsKt.getCompositeJobId(instruction)};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            Instant instant = instruction.getFireTimestamp();
            if (instant == null) {
                instant = timeOperator.getCurrentTime();
            }
            return new Trigger.CronTrigger(jobGroup, string, triggerGroup, string3, instant, instruction.getCronExpression());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/mappers/SchedulingInstructionMapper$RegularMapper;", "", "()V", "SIMPLE_TRIGGER_TRIGGER_ID_FORMAT", "", "toModel", "Lbox/tapsi/libs/scheduler/scheduler/Trigger;", "instruction", "Lbox/tapsi/libs/scheduler/scheduler/SchedulingInstruction$Regular;", "scheduler-starter"})
    private static final class RegularMapper {
        @NotNull
        public static final RegularMapper INSTANCE = new RegularMapper();
        @NotNull
        private static final String SIMPLE_TRIGGER_TRIGGER_ID_FORMAT = "%s_trigger";

        private RegularMapper() {
        }

        @NotNull
        public final Trigger toModel(@NotNull SchedulingInstruction.Regular instruction) {
            Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
            JobGroup jobGroup = instruction.getJobGroup();
            String string = SchedulingExtensionsKt.getCompositeJobId(instruction);
            TriggerGroup triggerGroup = instruction.getTriggerGroup();
            String string2 = SIMPLE_TRIGGER_TRIGGER_ID_FORMAT;
            Object[] objectArray = new Object[]{SchedulingExtensionsKt.getCompositeJobId(instruction)};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            return new Trigger.SimpleTrigger(jobGroup, string, triggerGroup, string3, instruction.getFireTimestamp(), null, 0, 96, null);
        }
    }
}

